/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import java.lang.reflect.Constructor;
import java.util.Optional;
import lombok.Generated;

public class TigerTypedConfigurationKey<T> {
    private final TigerConfigurationKey key;
    private final Optional<T> defaultValue;
    private final Constructor<T> typeConstructor;

    public TigerTypedConfigurationKey(String key, Class<T> type) {
        this(new TigerConfigurationKey(key), type);
    }

    public TigerTypedConfigurationKey(TigerConfigurationKey key, Class<T> type) {
        this.key = key;
        this.typeConstructor = type.getConstructor(String.class);
        this.defaultValue = Optional.empty();
    }

    public TigerTypedConfigurationKey(String key, Class<T> type, T defaultValue) {
        this(new TigerConfigurationKey(key), type, defaultValue);
    }

    public TigerTypedConfigurationKey(TigerConfigurationKey key, Class<T> type, T defaultValue) {
        this.key = key;
        this.typeConstructor = type.getConstructor(String.class);
        this.defaultValue = Optional.ofNullable(defaultValue);
    }

    public Optional<T> getValue() {
        return TigerGlobalConfiguration.readStringOptional(this.key.downsampleKey()).map(this::getInstance);
    }

    public T getValueOrDefault() {
        return this.getValue().or(() -> this.defaultValue).orElseThrow();
    }

    private T getInstance(String s) {
        return this.typeConstructor.newInstance(s);
    }

    public void putValue(T value) {
        TigerGlobalConfiguration.putValue(this.key.downsampleKey(), value);
    }

    @Generated
    public TigerConfigurationKey getKey() {
        return this.key;
    }
}

