/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common;

import de.gematik.test.tiger.common.config.TigerConfigurationLoader;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public final class TokenSubstituteHelper {
    public static final Deque<Pair<Character, ReplacerFunction>> REPLACER_ORDER = new ConcurrentLinkedDeque<Pair<Character, ReplacerFunction>>();

    public static String substitute(String value, TigerConfigurationLoader source) {
        String result = value;
        for (Pair<Character, ReplacerFunction> replacer : REPLACER_ORDER) {
            result = TokenSubstituteHelper.replacePlaceholderWithGivenIntro(result, ((Character)replacer.getKey()).charValue(), (ReplacerFunction)replacer.getValue(), source);
        }
        return result;
    }

    private static String replacePlaceholderWithGivenIntro(String str, char intro, ReplacerFunction placeholderResolver, TigerConfigurationLoader source) {
        String tokenStr = intro + "{";
        int varIdx = ((String)str).indexOf(tokenStr);
        while (varIdx != -1) {
            int endVar = ((String)str).indexOf(125, varIdx);
            if (endVar == -1) {
                return str;
            }
            String placeholderString = ((String)str).substring(varIdx + tokenStr.length(), endVar);
            Optional<String> valueOptional = placeholderResolver.replace(placeholderString, source);
            if (valueOptional.isPresent()) {
                str = ((String)str).substring(0, varIdx) + valueOptional.get() + ((String)str).substring(endVar + 1);
                varIdx = ((String)str).indexOf(tokenStr);
                continue;
            }
            varIdx = ((String)str).indexOf(tokenStr, varIdx + 1);
        }
        return str;
    }

    @Generated
    private TokenSubstituteHelper() {
    }

    static {
        REPLACER_ORDER.add((Pair<Character, ReplacerFunction>)Pair.of((Object)Character.valueOf('$'), (str, source) -> source.readStringOptional(str)));
        REPLACER_ORDER.add((Pair<Character, ReplacerFunction>)Pair.of((Object)Character.valueOf('!'), (str, source) -> TigerJexlExecutor.INSTANCE.evaluateJexlExpression(str, Optional.empty()).map(Object::toString)));
        REPLACER_ORDER.add((Pair<Character, ReplacerFunction>)Pair.of((Object)Character.valueOf('$'), (str, source) -> source.readStringOptional(str)));
    }

    public static interface ReplacerFunction {
        public Optional<String> replace(String var1, TigerConfigurationLoader var2);
    }
}

