/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.Properties;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerProperties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerProperties.class);
    private String buildVersion = "";
    private String buildDate = "";

    public TigerProperties(URL url) {
        Properties properties = new Properties();
        if (url == null) {
            log.warn("Unable to find build.properties at {}", (Object)url);
            this.buildVersion = "?.?.?";
            this.buildDate = ZonedDateTime.now().toLocalDate().toString();
        } else {
            try (InputStream inputStream = url.openStream();){
                properties.load(inputStream);
            }
            catch (FileNotFoundException fie) {
                log.warn("File 'build.properties' not found.");
            }
            catch (IOException e) {
                log.warn("Problems while reading 'build.properties'.");
            }
            Set<String> keys = properties.stringPropertyNames();
            for (String key : keys) {
                if (key.equalsIgnoreCase("tiger.version")) {
                    this.buildVersion = properties.getProperty(key);
                    continue;
                }
                if (!key.equalsIgnoreCase("tiger.buildDate")) continue;
                this.buildDate = properties.getProperty(key);
            }
        }
    }

    public TigerProperties() {
        this(ClassLoader.getSystemResource("build.properties"));
    }

    public String getFullBuildVersion() {
        return "Version: " + this.getBuildVersion() + " - " + this.getBuildDate();
    }

    @Generated
    public String getBuildVersion() {
        return this.buildVersion;
    }

    @Generated
    public String getBuildDate() {
        return this.buildDate;
    }
}

