/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.gematik.test.tiger.common.TokenSubstituteHelper;
import de.gematik.test.tiger.common.config.AbstractTigerConfigurationSource;
import de.gematik.test.tiger.common.config.BasicTigerConfigurationSource;
import de.gematik.test.tiger.common.config.DeprecatedKeysForbiddenUsageChecker;
import de.gematik.test.tiger.common.config.DuplicateMapKeysForbiddenConstructor;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerConfigurationKeyString;
import de.gematik.test.tiger.common.config.TigerTemplateSource;
import de.gematik.test.tiger.common.config.TigerThreadScopedConfigurationSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;

public class TigerConfigurationLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerConfigurationLoader.class);
    private ObjectMapper objectMapper;
    private List<AbstractTigerConfigurationSource> loadedSources;
    private List<TigerTemplateSource> loadedTemplates;

    public TigerConfigurationLoader() {
        this.initialize();
    }

    public void reset() {
        this.loadedSources.clear();
        this.loadedTemplates.clear();
        this.initializeObjectMapper();
    }

    public void initialize() {
        if (this.objectMapper == null) {
            this.initializeObjectMapper();
        }
        if (this.loadedSources == null) {
            this.loadedSources = new ArrayList<AbstractTigerConfigurationSource>();
        }
        if (this.loadedTemplates == null) {
            this.loadedTemplates = new ArrayList<TigerTemplateSource>();
        }
    }

    private void initializeObjectMapper() {
        this.objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).propertyNamingStrategy(PropertyNamingStrategies.LOWER_CASE)).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).build();
    }

    public String readString(String key) {
        return this.readStringOptional(key).orElseThrow(() -> new TigerConfigurationException("Could not find value for '" + key + "'"));
    }

    public String readString(String key, String defaultValue) {
        return this.readStringOptional(key).orElse(defaultValue);
    }

    public Optional<String> readStringOptional(String key) {
        TigerConfigurationKey splittedKey = new TigerConfigurationKey(TokenSubstituteHelper.substitute(key, this));
        return this.loadedSources.stream().sorted(Comparator.comparing(source -> source.getSourceType().getPrecedence())).filter(source -> source.getValues().containsKey(splittedKey)).map(source -> source.getValues().get(splittedKey)).findFirst();
    }

    public <T> Optional<T> instantiateConfigurationBean(Class<T> configurationBeanClass, String ... baseKeys) {
        this.initialize();
        JsonNode targetTree = this.convertToTree();
        TigerConfigurationKey configurationKey = new TigerConfigurationKey(baseKeys);
        for (TigerConfigurationKeyString key : configurationKey) {
            if (targetTree.get(key.getValue()) == null) {
                return Optional.empty();
            }
            targetTree = targetTree.get(key.getValue());
        }
        try {
            return Optional.of(this.objectMapper.treeToValue((TreeNode)targetTree, configurationBeanClass));
        }
        catch (JacksonException e) {
            log.debug("Error while converting the following tree: {}", (Object)this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)targetTree));
            throw new TigerConfigurationException("Error while reading configuration for class " + configurationBeanClass.getName() + " with base-keys " + baseKeys, e);
        }
    }

    public <T> T instantiateConfigurationBean(TypeReference<T> configurationBeanType, String ... baseKeys) {
        this.initialize();
        JsonNode targetTree = this.convertToTree();
        TigerConfigurationKey configurationKey = new TigerConfigurationKey(baseKeys);
        for (TigerConfigurationKeyString key : configurationKey) {
            if (targetTree.get(key.getValue()) == null) {
                return (T)this.objectMapper.readValue("[]", configurationBeanType);
            }
            targetTree = targetTree.get(key.getValue());
        }
        try {
            return (T)this.objectMapper.treeAsTokens((TreeNode)targetTree).readValueAs(configurationBeanType);
        }
        catch (JacksonException e) {
            log.debug("Error while converting the following tree: {}", (Object)this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)targetTree));
            throw new TigerConfigurationException("Error while reading configuration for class " + configurationBeanType.getType().getTypeName() + " with base-keys " + baseKeys, e);
        }
    }

    public void readFromYaml(String yamlSource, String ... baseKeys) {
        this.readFromYaml(yamlSource, SourceType.YAML, baseKeys);
    }

    public void readFromYaml(String yamlSource, SourceType sourceType, String ... baseKeys) {
        this.initialize();
        Yaml yaml = new Yaml((BaseConstructor)new DuplicateMapKeysForbiddenConstructor());
        HashMap<TigerConfigurationKey, String> valueMap = new HashMap<TigerConfigurationKey, String>();
        this.addYamlToMap(yaml.load(yamlSource), new TigerConfigurationKey(baseKeys), valueMap);
        DeprecatedKeysForbiddenUsageChecker.checkForDeprecatedKeys(valueMap);
        this.loadedSources.add(BasicTigerConfigurationSource.builder().values(valueMap).sourceType(sourceType).basePath(new TigerConfigurationKey(baseKeys)).build());
    }

    public boolean readBoolean(String key) {
        String rawValue = this.readString(key);
        if (rawValue.equals("1")) {
            return true;
        }
        return Boolean.parseBoolean(rawValue);
    }

    public boolean readBoolean(String key, boolean defValue) {
        String rawValue = this.readString(key, defValue ? "1" : "0");
        if (rawValue.equals("1")) {
            return true;
        }
        return Boolean.parseBoolean(rawValue);
    }

    public void readTemplates(String templatesYaml, String ... baseKeys) {
        Yaml yaml = new Yaml((BaseConstructor)new DuplicateMapKeysForbiddenConstructor());
        Object loadedYaml = yaml.load(templatesYaml);
        if (!(loadedYaml instanceof Map && ((Map)loadedYaml).containsKey("templates") && ((Map)loadedYaml).get("templates") instanceof List)) {
            throw new TigerConfigurationException("Error while loading templates: Expected templates-nodes with list of templates");
        }
        ((List)((Map)loadedYaml).get("templates")).stream().filter(o -> o instanceof Map).map(Map.class::cast).filter(m -> ((Map)m).containsKey("templateName")).forEach(m -> this.loadedTemplates.add(TigerTemplateSource.builder().templateName(((Map)m).get("templateName").toString()).targetPath(new TigerConfigurationKey(baseKeys)).values(this.addYamlToMap(m, new TigerConfigurationKey(), new HashMap<TigerConfigurationKey, String>())).build()));
    }

    public void loadEnvironmentVariables() {
        this.loadedSources.stream().filter(source -> source.getSourceType() == SourceType.ENV).findAny().ifPresent(this.loadedSources::remove);
        this.loadedSources.add(BasicTigerConfigurationSource.builder().basePath(new TigerConfigurationKey()).values(System.getenv().entrySet().stream().collect(Collectors.toMap(entry -> new TigerConfigurationKey((String)entry.getKey()), Map.Entry::getValue))).sourceType(SourceType.ENV).build());
    }

    public void loadSystemProperties() {
        this.loadedSources.stream().filter(source -> source.getSourceType() == SourceType.PROPERTIES).findAny().ifPresent(this.loadedSources::remove);
        this.loadedSources.add(BasicTigerConfigurationSource.builder().basePath(new TigerConfigurationKey()).values(System.getProperties().entrySet().stream().collect(Collectors.toMap(entry -> new TigerConfigurationKey(entry.getKey().toString()), entry -> entry.getValue().toString()))).sourceType(SourceType.PROPERTIES).build());
    }

    public Map<TigerConfigurationKey, String> retrieveMap() {
        Map<TigerConfigurationKey, String> loadedAndSortedProperties = new HashMap<TigerConfigurationKey, String>();
        for (AbstractTigerConfigurationSource configurationSource : this.loadedSources.stream().sorted(Comparator.comparing(AbstractTigerConfigurationSource::getSourceType)).collect(Collectors.toList())) {
            loadedAndSortedProperties = configurationSource.applyTemplatesAndAddValuesToMap(this.loadedTemplates, loadedAndSortedProperties);
        }
        this.replacePlaceholders(loadedAndSortedProperties);
        return loadedAndSortedProperties;
    }

    private JsonNode convertToTree() {
        ObjectNode result = new ObjectNode(this.objectMapper.getNodeFactory());
        for (Map.Entry<TigerConfigurationKey, String> entry : this.retrieveMap().entrySet()) {
            this.createAndReturnDeepPath(entry.getKey(), result).put(((TigerConfigurationKeyString)entry.getKey().get(entry.getKey().size() - 1)).getValue(), entry.getValue());
        }
        return this.mapObjectsToArrayWhereApplicable((JsonNode)result, this.objectMapper.getNodeFactory());
    }

    private void replacePlaceholders(Map<TigerConfigurationKey, String> loadedAndSortedProperties) {
        Map<TigerConfigurationKey, String> updatedValues = loadedAndSortedProperties.entrySet().stream().filter(entry -> ((String)entry.getValue()).contains("${") && ((String)entry.getValue()).contains("}")).map(entry -> Pair.of((Object)((TigerConfigurationKey)entry.getKey()), (Object)TokenSubstituteHelper.substitute((String)entry.getValue(), this))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        loadedAndSortedProperties.putAll(updatedValues);
    }

    private JsonNode mapObjectsToArrayWhereApplicable(JsonNode value, JsonNodeFactory nodeFactory) {
        if (value instanceof ObjectNode) {
            if (this.isArray((ObjectNode)value)) {
                return new ArrayNode(nodeFactory, StreamSupport.stream(Spliterators.spliteratorUnknownSize(value.fields(), 16), false).sorted(Comparator.comparing(Map.Entry::getKey)).map(Map.Entry::getValue).map(node -> this.mapObjectsToArrayWhereApplicable((JsonNode)node, nodeFactory)).collect(Collectors.toList()));
            }
            return new ObjectNode(nodeFactory, StreamSupport.stream(Spliterators.spliteratorUnknownSize(value.fields(), 16), false).map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)this.mapObjectsToArrayWhereApplicable((JsonNode)entry.getValue(), nodeFactory))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        return value;
    }

    private boolean isArray(ObjectNode value) {
        if (IteratorUtils.toList((Iterator)value.fieldNames()).stream().anyMatch(s -> !NumberUtils.isParsable((String)s.toString()))) {
            return false;
        }
        List keys = IteratorUtils.toList((Iterator)value.fieldNames()).stream().mapToInt(s -> Integer.parseInt(s.toString())).sorted().boxed().collect(Collectors.toList());
        int i = 0;
        for (Integer key : keys) {
            if (key == i++) continue;
            return false;
        }
        return true;
    }

    private ObjectNode createAndReturnDeepPath(List<TigerConfigurationKeyString> keys, ObjectNode position) {
        if (keys.size() > 1) {
            for (TigerConfigurationKeyString key : keys.subList(0, keys.size() - 1)) {
                String homogenizedKey = this.homogenizeKeysInMapAndReturnCorrectedKey(position, key);
                if (!position.has(homogenizedKey)) {
                    position.putObject(homogenizedKey);
                }
                if (!(position.get(homogenizedKey) instanceof ObjectNode)) continue;
                position = (ObjectNode)position.get(homogenizedKey);
            }
        }
        return position;
    }

    private String homogenizeKeysInMapAndReturnCorrectedKey(ObjectNode position, TigerConfigurationKeyString key) {
        Iterator it = position.fieldNames();
        while (it.hasNext()) {
            String toBeReplacedKey = (String)it.next();
            if (key.getValue().equals(toBeReplacedKey) || !key.getValue().equalsIgnoreCase(toBeReplacedKey)) continue;
            if (!toBeReplacedKey.equals(toBeReplacedKey.toLowerCase())) {
                return toBeReplacedKey;
            }
            JsonNode leaf = position.remove(toBeReplacedKey);
            position.set(key.getValue(), leaf);
            return key.getValue();
        }
        return key.getValue();
    }

    private Map<TigerConfigurationKey, String> addYamlToMap(Object value, TigerConfigurationKey baseKeys, Map<TigerConfigurationKey, String> valueMap) {
        if (value instanceof Map) {
            ((Map)value).entrySet().forEach(entry -> {
                TigerConfigurationKey newList = new TigerConfigurationKey(baseKeys);
                newList.add((String)entry.getKey());
                this.addYamlToMap(entry.getValue(), newList, valueMap);
            });
        } else if (value instanceof List) {
            int counter = 0;
            for (Object entry2 : (List)value) {
                TigerConfigurationKey newList = new TigerConfigurationKey(baseKeys);
                newList.add(TigerConfigurationKeyString.wrapAsKey(Integer.toString(counter++)));
                this.addYamlToMap(entry2, newList, valueMap);
            }
        } else if (value != null) {
            valueMap.put(baseKeys, value.toString());
        }
        return valueMap;
    }

    public Map<String, String> readMap(String ... baseKeys) {
        TigerConfigurationKey reference = new TigerConfigurationKey(baseKeys);
        return this.retrieveMap().entrySet().stream().filter(entry -> ((TigerConfigurationKey)entry.getKey()).isBelow(reference)).collect(Collectors.toMap(entry -> ((TigerConfigurationKey)entry.getKey()).subtractFromBeginning(reference).downsampleKey(), e -> (String)e.getValue()));
    }

    public List<AbstractTigerConfigurationSource> listSources() {
        return Collections.unmodifiableList(this.loadedSources);
    }

    public void putValue(String key, String value) {
        this.putValue(key, value, SourceType.RUNTIME_EXPORT);
    }

    public void putValue(String key, Object value) {
        try {
            Yaml yaml = new Yaml((BaseConstructor)new DuplicateMapKeysForbiddenConstructor());
            HashMap<TigerConfigurationKey, String> valueMap = new HashMap<TigerConfigurationKey, String>();
            this.addYamlToMap(yaml.load(this.objectMapper.writeValueAsString(value)), new TigerConfigurationKey(key), valueMap);
            this.loadedSources.add(BasicTigerConfigurationSource.builder().values(valueMap).sourceType(SourceType.RUNTIME_EXPORT).basePath(new TigerConfigurationKey(key)).build());
        }
        catch (JsonProcessingException e) {
            throw new TigerConfigurationException("Error during serialization", e);
        }
    }

    public void putValue(String key, String value, SourceType sourceType) {
        Optional<AbstractTigerConfigurationSource> configurationSource = this.loadedSources.stream().filter(source -> source.getSourceType() == sourceType).findAny();
        if (configurationSource.isEmpty()) {
            AbstractTigerConfigurationSource newSource = sourceType == SourceType.THREAD_CONTEXT ? new TigerThreadScopedConfigurationSource() : new BasicTigerConfigurationSource(sourceType);
            this.loadedSources.add(newSource);
            newSource.putValue(new TigerConfigurationKey(key), value);
        } else {
            configurationSource.get().getValues().put(new TigerConfigurationKey(key), value);
        }
    }

    public void addConfigurationSource(AbstractTigerConfigurationSource configurationSource) {
        this.loadedSources.add(configurationSource);
    }

    public boolean removeConfigurationSource(AbstractTigerConfigurationSource configurationSource) {
        return this.loadedSources.remove(configurationSource);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

