/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import de.gematik.test.tiger.common.config.TigerConfigurationException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.parser.ParserException;

public class DuplicateMapKeysForbiddenConstructor
extends SafeConstructor {
    protected Map<Object, Object> constructMapping(MappingNode node) {
        try {
            List keys = node.getValue().stream().map(v -> ((ScalarNode)v.getKeyNode()).getValue()).collect(Collectors.toList());
            Set duplicates = this.findDuplicates(keys);
            if (!duplicates.isEmpty()) {
                throw new TigerConfigurationException("Duplicate keys in yaml file ('" + String.join((CharSequence)",", duplicates) + "')!");
            }
        }
        catch (Exception e) {
            throw new TigerConfigurationException("Duplicate keys in yaml file!", e);
        }
        try {
            return super.constructMapping(node);
        }
        catch (IllegalStateException e) {
            throw new ParserException("while parsing MappingNode", node.getStartMark(), e.getMessage(), node.getEndMark());
        }
    }

    private <T> Set<T> findDuplicates(Collection<T> collection) {
        HashSet uniques = new HashSet();
        return collection.stream().filter(e -> !uniques.add(e)).collect(Collectors.toSet());
    }
}

