/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerConfigurationHelper<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerConfigurationHelper.class);
    private static final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final ObjectMapper objMapper = new ObjectMapper();

    public T yamlToConfig(String yamlFile, String product, Class<T> cfgClazz) {
        JSONObject json = TigerConfigurationHelper.yamlToJson(yamlFile);
        TigerConfigurationHelper.overwriteWithSysPropsAndEnvVars(product.toUpperCase(), product, json);
        return (T)objMapper.readValue(json.toString(), cfgClazz);
    }

    public static JSONObject yamlToJson(String yamlFile) {
        Object yamlCfg = yamlMapper.readValue(IOUtils.toString((URI)Path.of(yamlFile, new String[0]).toUri(), (Charset)StandardCharsets.UTF_8), Object.class);
        return new JSONObject(objMapper.writeValueAsString(yamlCfg));
    }

    public static JSONObject yamlStringToJson(String yaml) {
        Object yamlCfg = yamlMapper.readValue(yaml, Object.class);
        return new JSONObject(objMapper.writeValueAsString(yamlCfg));
    }

    public T jsonToConfig(String jsonFile, Class<T> cfgClazz) {
        return (T)objMapper.readValue(IOUtils.toString((URI)Path.of(jsonFile, new String[0]).toUri(), (Charset)StandardCharsets.UTF_8), cfgClazz);
    }

    public T jsonStringToConfig(String jsonStr, Class<T> cfgClazz) {
        return (T)objMapper.readValue(jsonStr, cfgClazz);
    }

    public static String toJson(Object cfg) {
        return objMapper.writerWithDefaultPrettyPrinter().writeValueAsString(cfg);
    }

    public static String toYaml(Object cfg) {
        return yamlMapper.writerWithDefaultPrettyPrinter().writeValueAsString(cfg);
    }

    public static void overwriteWithSysPropsAndEnvVars(String rootEnv, String rootProps, JSONObject json) {
        json.keys().forEachRemaining(key -> {
            Object obj = json.get(key);
            if (obj instanceof JSONObject) {
                TigerConfigurationHelper.overwriteWithSysPropsAndEnvVars(rootEnv + "_" + key.toUpperCase(), rootProps + "." + key, (JSONObject)obj);
            } else if (obj instanceof JSONArray) {
                TigerConfigurationHelper.overwriteWithSysPropsAndEnvVars(rootEnv + "_" + key.toUpperCase(), rootProps + "." + key, (JSONArray)obj);
            } else {
                log.info("checking for env " + rootEnv + "_" + key.toUpperCase() + ":" + obj);
                String value = System.getProperty(rootProps + "." + key, System.getenv(rootEnv + "_" + key.toUpperCase()));
                if (value != null) {
                    log.info("modifying " + rootEnv + "_" + key.toUpperCase() + ":" + obj);
                    json.put(key, (Object)value);
                }
            }
        });
    }

    public static void applyTemplate(JSONArray cfgArray, String templateKey, JSONArray templates, String templateIdKey) {
        for (int i = 0; i < cfgArray.length(); ++i) {
            JSONObject json = cfgArray.getJSONObject(i);
            String templateId = json.getString(templateKey);
            for (int j = 0; j < templates.length(); ++j) {
                JSONObject jsonTemplate = templates.getJSONObject(j);
                if (!jsonTemplate.getString(templateIdKey).equals(templateId)) continue;
                jsonTemplate.keySet().stream().filter(key -> jsonTemplate.get(key) != null).filter(key -> jsonTemplate.get(key) instanceof JSONArray).filter(key -> !jsonTemplate.getJSONArray(key).isEmpty()).filter(key -> !json.has(key) || json.get(key) == null || json.getJSONArray(key).isEmpty()).forEach(key -> json.put(key, (Object)new JSONArray(jsonTemplate.getJSONArray(key))));
                jsonTemplate.keySet().stream().filter(key -> jsonTemplate.get(key) != null).filter(key -> !(jsonTemplate.get(key) instanceof JSONArray)).filter(key -> !json.has(key) || json.get(key) == null).forEach(key -> json.put(key, jsonTemplate.get(key)));
            }
        }
    }

    private static void overwriteWithSysPropsAndEnvVars(String rootEnv, String rootProps, JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object obj = jsonArray.get(i);
            if (obj instanceof JSONObject) {
                TigerConfigurationHelper.overwriteWithSysPropsAndEnvVars(rootEnv + "_" + i, rootProps + "." + i, (JSONObject)obj);
                continue;
            }
            if (obj instanceof JSONArray) {
                TigerConfigurationHelper.overwriteWithSysPropsAndEnvVars(rootEnv + "_" + i, rootProps + "." + i, (JSONArray)obj);
                continue;
            }
            log.info("checking for env " + rootEnv + "_" + i + ":" + obj);
            String value = System.getProperty(rootProps + "." + i, System.getenv(rootEnv + "_" + i));
            if (value == null) continue;
            log.info("modifying " + rootEnv + "_" + i + ":" + obj);
            jsonArray.put(i, (Object)value);
        }
    }
}

