/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.pki;

import de.gematik.rbellogger.util.CryptoLoader;
import de.gematik.rbellogger.util.RbelPkiIdentity;
import de.gematik.test.tiger.common.exceptions.TigerFileSeparatorException;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public class TigerPkiIdentityLoader {
    public static TigerPkiIdentity loadRbelPkiIdentity(String information) {
        List<String> informationSplits = Stream.of(information.split(";")).map(String::trim).collect(Collectors.toUnmodifiableList());
        StoreType storeType = TigerPkiIdentityLoader.extractStoreType(informationSplits).or(() -> TigerPkiIdentityLoader.guessStoreType(informationSplits)).orElseThrow(() -> new TigerPkiIdentityLoaderException("Unable to determine store-type for input '" + information + "'!"));
        List<Pair<String, byte[]>> fileNamesAndContent = TigerPkiIdentityLoader.extractFileNames(informationSplits);
        List<String> fileNames = fileNamesAndContent.stream().map(Pair::getLeft).collect(Collectors.toUnmodifiableList());
        if (fileNamesAndContent.isEmpty() || !storeType.isKeystore() && fileNamesAndContent.size() < 2) {
            throw new IllegalArgumentException("Could not find file information in parameters (maybe the files could not be found?)! (" + information + ")");
        }
        if (storeType.isKeystore()) {
            return TigerPkiIdentityLoader.loadKeystore((byte[])fileNamesAndContent.get(0).getRight(), TigerPkiIdentityLoader.guessPasswordField(informationSplits, fileNames, storeType), storeType.name());
        }
        RbelPkiIdentity rbelPkiIdentity = TigerPkiIdentityLoader.loadCertKeyPair(storeType, fileNamesAndContent);
        TigerPkiIdentity tigerPkiIdentity = new TigerPkiIdentity();
        tigerPkiIdentity.setCertificate(rbelPkiIdentity.getCertificate());
        tigerPkiIdentity.setPrivateKey(rbelPkiIdentity.getPrivateKey());
        return tigerPkiIdentity;
    }

    private static String guessPasswordField(List<String> informationSplits, List<String> fileNames, StoreType storeType) {
        return informationSplits.stream().filter(part -> !fileNames.contains(part)).filter(part -> !storeType.name().equalsIgnoreCase((String)part)).findAny().orElseThrow(() -> new TigerPkiIdentityLoaderException("Unable to guess password from parts " + informationSplits));
    }

    private static RbelPkiIdentity loadCertKeyPair(StoreType storeType, List<Pair<String, byte[]>> fileNamesAndContent) {
        byte[] data0 = (byte[])fileNamesAndContent.get(0).getRight();
        byte[] data1 = (byte[])fileNamesAndContent.get(1).getRight();
        if (storeType == StoreType.PKCS1) {
            try {
                return CryptoLoader.getIdentityFromPemAndPkcs1((byte[])data0, (byte[])data1);
            }
            catch (Exception e) {
                return CryptoLoader.getIdentityFromPemAndPkcs1((byte[])data1, (byte[])data0);
            }
        }
        try {
            return CryptoLoader.getIdentityFromPemAndPkcs8((byte[])data0, (byte[])data1);
        }
        catch (Exception e) {
            return CryptoLoader.getIdentityFromPemAndPkcs8((byte[])data1, (byte[])data0);
        }
    }

    private static List<Pair<String, byte[]>> extractFileNames(List<String> informationSplits) {
        return informationSplits.stream().map(part -> Pair.of((Object)part, TigerPkiIdentityLoader.loadFileOrResourceData(part))).filter(pair -> ((Optional)pair.getValue()).isPresent()).map(pair -> Pair.of((Object)((String)pair.getLeft()), (Object)((byte[])((Optional)pair.getRight()).get()))).collect(Collectors.toUnmodifiableList());
    }

    private static Optional<StoreType> extractStoreType(List<String> informationSplits) {
        return informationSplits.stream().map(StoreType::findStoreTypeForString).filter(Optional::isPresent).map(Optional::get).findAny();
    }

    private static Optional<StoreType> guessStoreType(List<String> informationSplits) {
        return informationSplits.stream().flatMap(part -> Stream.of(part.split("\\."))).map(StoreType::findStoreTypeForString).filter(Optional::isPresent).map(Optional::get).findAny();
    }

    private static TigerPkiIdentity loadKeystore(byte[] content, String password, String keystoreType) {
        try {
            KeyStore ks = KeyStore.getInstance(keystoreType);
            ks.load(new ByteArrayInputStream(content), password.toCharArray());
            TigerPkiIdentity result = new TigerPkiIdentity();
            Iterator<String> it = ks.aliases().asIterator();
            while (it.hasNext()) {
                String alias = it.next();
                if (ks.isKeyEntry(alias)) {
                    result.setCertificate((X509Certificate)ks.getCertificate(alias));
                    result.setPrivateKey((PrivateKey)ks.getKey(alias, password.toCharArray()));
                    Certificate[] certificateChain = ks.getCertificateChain(alias);
                    for (int i = 1; i < certificateChain.length; ++i) {
                        result.addCertificateToCertificateChain((X509Certificate)certificateChain[i]);
                    }
                    continue;
                }
                result.addCertificateToCertificateChain((X509Certificate)ks.getCertificate(alias));
            }
            if (result.getPrivateKey() == null) {
                throw new TigerPkiIdentityLoaderException("Error while loading keystore: No matching entry found!");
            }
            return result;
        }
        catch (Exception e) {
            throw new TigerPkiIdentityLoaderException("Error while loading keystore", e);
        }
    }

    private static Optional<byte[]> loadFileOrResourceData(String entityLocation) {
        if (StringUtils.isEmpty((CharSequence)entityLocation)) {
            throw new IllegalArgumentException("Trying to load data from empty location! (value is '" + entityLocation + "')");
        }
        if (entityLocation.contains("\\")) {
            throw new TigerFileSeparatorException("Please use forward slash (/) as a file separator");
        }
        if (!entityLocation.startsWith("classpath:") && new File(entityLocation).exists()) {
            try {
                return Optional.ofNullable(FileUtils.readFileToByteArray((File)new File(entityLocation)));
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        if (entityLocation.startsWith("classpath:")) {
            return TigerPkiIdentityLoader.loadResourceData(entityLocation.replaceFirst("classpath:", ""));
        }
        return TigerPkiIdentityLoader.loadResourceData(entityLocation);
    }

    private static Optional<byte[]> loadResourceData(String name) {
        Optional<byte[]> optional;
        block8: {
            InputStream rawStream = TigerPkiIdentityLoader.class.getClassLoader().getResourceAsStream(name);
            try {
                optional = Optional.ofNullable(rawStream.readAllBytes());
                if (rawStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rawStream != null) {
                        try {
                            rawStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return Optional.empty();
                }
            }
            rawStream.close();
        }
        return optional;
    }

    static {
        BouncyCastleJsseProvider bcJsseProv = new BouncyCastleJsseProvider();
        BouncyCastleProvider bcprov = new BouncyCastleProvider();
        Security.addProvider((Provider)bcprov);
        Security.addProvider((Provider)bcJsseProv);
    }

    public static class TigerPkiIdentityLoaderException
    extends RuntimeException {
        public TigerPkiIdentityLoaderException(String message, Exception e) {
            super(message, e);
        }

        public TigerPkiIdentityLoaderException(String message) {
            super(message);
        }
    }

    public static enum StoreType {
        PKCS12(true, "P12"),
        JKS(true, new String[0]),
        BKS(true, new String[0]),
        PKCS8(false, new String[0]),
        PKCS1(false, new String[0]);

        private final List<String> names;
        private final boolean isKeystore;

        private StoreType(boolean isKeystore, String ... alternateNames) {
            ArrayList<String> names = new ArrayList<String>(List.of(alternateNames));
            names.add(this.name());
            this.names = Collections.unmodifiableList(names);
            this.isKeystore = isKeystore;
        }

        static Optional<StoreType> findStoreTypeForString(String value) {
            for (StoreType type : StoreType.values()) {
                for (String candidateName : type.getNames()) {
                    if (!candidateName.equalsIgnoreCase(value)) continue;
                    return Optional.of(type);
                }
            }
            return Optional.empty();
        }

        @Generated
        public List<String> getNames() {
            return this.names;
        }

        @Generated
        public boolean isKeystore() {
            return this.isKeystore;
        }
    }
}

