/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import de.gematik.test.tiger.common.config.AbstractTigerConfigurationSource;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerTemplateSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class TigerThreadScopedConfigurationSource
extends AbstractTigerConfigurationSource {
    private final Map<Long, Map<TigerConfigurationKey, String>> threadIdToValuesMap = new ConcurrentHashMap<Long, Map<TigerConfigurationKey, String>>();

    public TigerThreadScopedConfigurationSource() {
        super(SourceType.THREAD_CONTEXT);
    }

    @Override
    public Map<TigerConfigurationKey, String> applyTemplatesAndAddValuesToMap(List<TigerTemplateSource> loadedTemplates, Map<TigerConfigurationKey, String> loadedAndSortedProperties) {
        HashMap<TigerConfigurationKey, String> finalValues = new HashMap<TigerConfigurationKey, String>();
        finalValues.putAll(loadedAndSortedProperties);
        finalValues.putAll(this.getValues());
        List<List> appliedTemplates = loadedTemplates.stream().map(template -> template.applyToAllApplicable(this, finalValues)).flatMap(Collection::stream).collect(Collectors.toList());
        appliedTemplates.forEach(key -> finalValues.remove(key));
        return finalValues;
    }

    @Override
    public Map<TigerConfigurationKey, String> getValues() {
        long threadId = Thread.currentThread().getId();
        if (this.threadIdToValuesMap.containsKey(threadId)) {
            return this.threadIdToValuesMap.get(threadId);
        }
        return Map.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putValue(TigerConfigurationKey key, String value) {
        long threadId = Thread.currentThread().getId();
        Map<Long, Map<TigerConfigurationKey, String>> map = this.threadIdToValuesMap;
        synchronized (map) {
            if (!this.threadIdToValuesMap.containsKey(threadId)) {
                this.threadIdToValuesMap.put(threadId, new ConcurrentHashMap());
            }
            this.threadIdToValuesMap.get(threadId).put(key, value);
        }
    }
}

