/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import de.gematik.test.tiger.common.config.TigerConfigurationKeyString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections.ListUtils;

public class TigerConfigurationKey
extends ArrayList<TigerConfigurationKeyString> {
    private static final String ALL_SNAKE_AND_UPPERCASE_REGEX = "([A-Z0-9]+_)*[A-Z0-9]+";

    public TigerConfigurationKey(TigerConfigurationKey baseKeys) {
        super(baseKeys);
    }

    public TigerConfigurationKey(String ... baseKeys) {
        super(TigerConfigurationKey.splitKeys(baseKeys));
    }

    public TigerConfigurationKey(String[] baseKeys, String ... additionalKeys) {
        super(TigerConfigurationKey.splitKeys(baseKeys, additionalKeys));
    }

    public TigerConfigurationKey(TigerConfigurationKey baseKey, String key) {
        super(ListUtils.sum((List)baseKey, List.of(new TigerConfigurationKeyString(key))));
    }

    public TigerConfigurationKey(List<TigerConfigurationKeyString> list) {
        super(list);
    }

    public TigerConfigurationKey() {
    }

    private static List<TigerConfigurationKeyString> splitKeys(String[] baseKeys, String[] additionalKeys) {
        List<TigerConfigurationKeyString> keys = TigerConfigurationKey.splitKeys(baseKeys);
        keys.addAll(TigerConfigurationKey.splitKeys(additionalKeys));
        return keys;
    }

    private static List<TigerConfigurationKeyString> splitKey(String key) {
        if (key.matches(ALL_SNAKE_AND_UPPERCASE_REGEX)) {
            return Stream.of(key.split("_")).map(String::toLowerCase).map(TigerConfigurationKeyString::wrapAsKey).collect(Collectors.toList());
        }
        return Stream.of(key.split("\\.")).map(TigerConfigurationKeyString::wrapAsKey).collect(Collectors.toList());
    }

    private static List<TigerConfigurationKeyString> splitKeys(String ... keys) {
        return Stream.of(keys).map(TigerConfigurationKey::splitKey).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String downsampleKey() {
        return this.stream().map(TigerConfigurationKeyString::asLowerCase).collect(Collectors.joining("."));
    }

    public boolean isBelow(TigerConfigurationKey reference) {
        if (reference == null || reference.size() >= this.size()) {
            return false;
        }
        for (int i = 0; i < reference.size(); ++i) {
            if (((TigerConfigurationKeyString)reference.get(i)).equals(this.get(i))) continue;
            return false;
        }
        return true;
    }

    public TigerConfigurationKey subtractFromBeginning(TigerConfigurationKey reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Could not subtract null reference");
        }
        if (reference.size() >= this.size()) {
            throw new IllegalArgumentException("Could not subtract longer reference from value");
        }
        return new TigerConfigurationKey(this.subList(reference.size(), this.size()));
    }

    public boolean containsKey(String key) {
        return this.downsampleKey().matches(key);
    }

    @Override
    @Generated
    public String toString() {
        return "TigerConfigurationKey()";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerConfigurationKey)) {
            return false;
        }
        TigerConfigurationKey other = (TigerConfigurationKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerConfigurationKey;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

