/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.banner;

import com.github.dtmo.jfiglet.FigFontResources;
import com.github.dtmo.jfiglet.FigletRenderer;
import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.exceptions.TigerOsException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Banner {
    private static FigletRenderer figletRenderer;

    private Banner() {
    }

    public static String toBannerStr(String msg, String ansiColors) {
        return ansiColors + StringUtils.repeat((char)'=', (int)100) + RbelAnsiColors.RESET + "\n" + Banner.toBannerLines(msg).stream().map(line -> Ansi.colorize(line, ansiColors)).collect(Collectors.joining("\n")) + "\n" + Ansi.colorize(StringUtils.repeat((char)'=', (int)100), ansiColors);
    }

    public static String toTextStr(String msg, String colorName) {
        String ansiColors = RbelAnsiColors.seekColor((String)colorName.toLowerCase()).toString();
        return Ansi.colorize(msg, ansiColors);
    }

    public static String toBannerStrWithCOLOR(String msg, String colorName) {
        String ansiColors = RbelAnsiColors.seekColor((String)colorName.toLowerCase()).toString();
        return Ansi.colorize(StringUtils.repeat((char)'=', (int)100), ansiColors) + "\n" + Banner.toBannerLines(msg).stream().map(line -> Ansi.colorize(line, ansiColors)).collect(Collectors.joining("\n")) + "\n" + Ansi.colorize(StringUtils.repeat((char)'=', (int)100), ansiColors);
    }

    private static List<String> toBannerLines(String msg) {
        return Arrays.asList(figletRenderer.renderText(msg).split("\n"));
    }

    public static void shout(String msg) {
        Banner.shout(msg, RbelAnsiColors.YELLOW_BOLD.toString());
    }

    public static void shout(String msg, String ansiColors) {
        Banner.toBannerLines(msg).forEach(line -> System.out.println(Ansi.colorize(line, ansiColors)));
    }

    public static void setFont(String fontName) {
        try {
            figletRenderer = new FigletRenderer(FigFontResources.loadFigFontResource((String)fontName));
        }
        catch (IOException ioe) {
            throw new TigerOsException("Unable to load font " + fontName, ioe);
        }
    }

    static {
        Banner.setFont("standard.flf");
    }
}

