/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.jexl;

import de.gematik.test.tiger.common.jexl.InlineJexlToolbox;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;

public class TigerJexlExecutor {
    private static final Map<String, Object> NAMESPACE_MAP = new HashMap<String, Object>();

    public static String execute(String value) {
        JexlExpression expression = TigerJexlExecutor.buildExpression(value);
        MapContext mapContext = new MapContext();
        return Optional.ofNullable(expression.evaluate((JexlContext)mapContext)).map(Object::toString).orElseThrow(() -> new TigerJexlException("Error while executing expression, got null result. Expression evaluated: " + value));
    }

    private static JexlExpression buildExpression(String jexlExpression) {
        JexlEngine jexlEngine = new JexlBuilder().namespaces(NAMESPACE_MAP).strict(true).create();
        return jexlEngine.createExpression(jexlExpression);
    }

    public static void registerAdditionalNamespace(String namespace, Object value) {
        NAMESPACE_MAP.put(namespace, value);
    }

    public static void deregisterNamespace(String namespace) {
        NAMESPACE_MAP.remove(namespace);
    }

    static {
        NAMESPACE_MAP.put(null, InlineJexlToolbox.class);
    }

    private static class TigerJexlException
    extends RuntimeException {
        public TigerJexlException(String s) {
            super(s);
        }
    }
}

