/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.data.config.tigerProxy;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyType;
import de.gematik.test.tiger.common.exceptions.TigerProxyToForwardProxyException;
import de.gematik.test.tiger.common.exceptions.TigerUnknownProtocolException;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.proxyconfiguration.ProxyConfiguration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ForwardProxyInfo {
    private String hostname;
    private Integer port;
    private TigerProxyType type;
    private String username;
    private String password;

    public Optional<ProxyConfiguration> createMockServerProxyConfiguration() {
        if (StringUtils.isEmpty((CharSequence)this.hostname)) {
            return Optional.empty();
        }
        if (StringUtils.equals((CharSequence)this.hostname, (CharSequence)"$SYSTEM")) {
            return this.convertSystemProxyConfig();
        }
        return Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)Optional.ofNullable(this.type).map(this::toMockServerType).orElse(ProxyConfiguration.Type.HTTPS), (String)(this.hostname + ":" + this.getProxyPort(String.valueOf(this.port), this.type)), (String)this.username, (String)this.password));
    }

    private Optional<ProxyConfiguration> useProxyWithSystemProperties(String proxyProtocol) {
        ProxyConfiguration.Type proxyType = this.toMockServerType(this.getProxyProtocol(proxyProtocol));
        String proxyHost = System.getProperty(proxyProtocol + ".proxyHost");
        String proxyPort = System.getProperty(proxyProtocol + ".proxyPort");
        String proxyUser = System.getProperty(proxyProtocol + ".proxyUser");
        String proxyPassword = System.getProperty(proxyProtocol + ".proxyPassword");
        if (StringUtils.isEmpty((CharSequence)proxyHost)) {
            return Optional.empty();
        }
        if (proxyUser != null || proxyPassword != null) {
            if (proxyUser == null) {
                throw new TigerProxyToForwardProxyException("Could not convert proxy configuration: proxyUser == null, proxyPassword != null");
            }
            if (proxyPassword == null) {
                throw new TigerProxyToForwardProxyException("Could not convert proxy configuration: proxyUser != null, proxyPassword == null");
            }
            return Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)proxyType, (String)(proxyHost + ":" + this.getProxyPort(proxyPort, this.getProxyProtocol(proxyProtocol))), (String)proxyUser, (String)proxyPassword));
        }
        return Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)proxyType, (String)(proxyHost + ":" + this.getProxyPort(proxyPort, this.getProxyProtocol(proxyProtocol)))));
    }

    private Optional<ProxyConfiguration> useProxyAsEnvVar(String envProxyType) {
        String httpProxyAsEnv = System.getenv(envProxyType);
        if (StringUtils.isEmpty((CharSequence)httpProxyAsEnv)) {
            return Optional.empty();
        }
        URI proxyAsUri = URI.create(httpProxyAsEnv);
        if (proxyAsUri.getHost() == null || proxyAsUri.getScheme() == null) {
            throw new TigerProxyToForwardProxyException("No proxy host or no proxy protocol specified.");
        }
        ProxyConfiguration.Type proxyType = this.toMockServerType(this.getProxyProtocol(proxyAsUri.getScheme()));
        String proxyUsernamePassword = proxyAsUri.getUserInfo();
        String proxyPort = this.getProxyPort(String.valueOf(proxyAsUri.getPort()), this.getProxyProtocol(proxyAsUri.getScheme()));
        if (proxyUsernamePassword == null) {
            return Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)proxyType, (String)(proxyAsUri.getHost() + ":" + proxyPort)));
        }
        if (!proxyUsernamePassword.contains(":")) {
            throw new TigerProxyToForwardProxyException("Could not convert proxy configuration: either username or password are not present in the env variable");
        }
        return Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)proxyType, (String)(proxyAsUri.getHost() + ":" + proxyPort), (String)proxyUsernamePassword.split(":")[0], (String)proxyUsernamePassword.split(":")[1]));
    }

    private ProxyConfiguration.Type toMockServerType(TigerProxyType type) throws TigerUnknownProtocolException {
        if (type == TigerProxyType.HTTP) {
            return ProxyConfiguration.Type.HTTP;
        }
        if (type == TigerProxyType.HTTPS) {
            return ProxyConfiguration.Type.HTTPS;
        }
        throw new TigerUnknownProtocolException("Protocol of type " + type.toString() + " not specified for proxies");
    }

    private Optional<ProxyConfiguration> convertSystemProxyConfig() {
        return this.useProxyWithSystemProperties("http").or(() -> this.useProxyWithSystemProperties("https")).or(() -> this.useProxyAsEnvVar("http_proxy")).or(() -> this.useProxyAsEnvVar("https_proxy"));
    }

    private TigerProxyType getProxyProtocol(String proxyProtocol) {
        if (proxyProtocol.equalsIgnoreCase("http")) {
            return TigerProxyType.HTTP;
        }
        if (proxyProtocol.equalsIgnoreCase("https")) {
            return TigerProxyType.HTTPS;
        }
        throw new TigerUnknownProtocolException("Protocol of type " + proxyProtocol + " not specified for proxies");
    }

    private String getProxyPort(String proxyPort, TigerProxyType type) {
        if (proxyPort == null || proxyPort.equals("null") || proxyPort.equals("-1")) {
            if (type == TigerProxyType.HTTP) {
                return "80";
            }
            if (type == TigerProxyType.HTTPS) {
                return "443";
            }
        }
        return proxyPort;
    }

    @Generated
    private static TigerProxyType $default$type() {
        return TigerProxyType.HTTP;
    }

    @Generated
    public static ForwardProxyInfoBuilder builder() {
        return new ForwardProxyInfoBuilder();
    }

    @ConstructorProperties(value={"hostname", "port", "type", "username", "password"})
    @Generated
    public ForwardProxyInfo(String hostname, Integer port, TigerProxyType type, String username, String password) {
        this.hostname = hostname;
        this.port = port;
        this.type = type;
        this.username = username;
        this.password = password;
    }

    @Generated
    public ForwardProxyInfo() {
        this.type = ForwardProxyInfo.$default$type();
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public TigerProxyType getType() {
        return this.type;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setType(TigerProxyType type) {
        this.type = type;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ForwardProxyInfo)) {
            return false;
        }
        ForwardProxyInfo other = (ForwardProxyInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        TigerProxyType this$type = this.getType();
        TigerProxyType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ForwardProxyInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        TigerProxyType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ForwardProxyInfo(hostname=" + this.getHostname() + ", port=" + this.getPort() + ", type=" + this.getType() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }

    @Generated
    public static class ForwardProxyInfoBuilder {
        @Generated
        private String hostname;
        @Generated
        private Integer port;
        @Generated
        private boolean type$set;
        @Generated
        private TigerProxyType type$value;
        @Generated
        private String username;
        @Generated
        private String password;

        @Generated
        ForwardProxyInfoBuilder() {
        }

        @Generated
        public ForwardProxyInfoBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Generated
        public ForwardProxyInfoBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        @Generated
        public ForwardProxyInfoBuilder type(TigerProxyType type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        @Generated
        public ForwardProxyInfoBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public ForwardProxyInfoBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public ForwardProxyInfo build() {
            TigerProxyType type$value = this.type$value;
            if (!this.type$set) {
                type$value = ForwardProxyInfo.$default$type();
            }
            return new ForwardProxyInfo(this.hostname, this.port, type$value, this.username, this.password);
        }

        @Generated
        public String toString() {
            return "ForwardProxyInfo.ForwardProxyInfoBuilder(hostname=" + this.hostname + ", port=" + this.port + ", type$value=" + this.type$value + ", username=" + this.username + ", password=" + this.password + ")";
        }
    }
}

