/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import com.fasterxml.jackson.core.type.TypeReference;
import de.gematik.test.tiger.common.TokenSubstituteHelper;
import de.gematik.test.tiger.common.config.AbstractTigerConfigurationSource;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerConfigurationLoader;
import de.gematik.test.tiger.common.data.config.AdditionalYamlProperty;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerGlobalConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerGlobalConfiguration.class);
    private static TigerConfigurationLoader globalConfigurationLoader = new TigerConfigurationLoader();
    private static boolean requireTigerYaml = false;
    private static boolean initialized = false;

    public static synchronized void reset() {
        globalConfigurationLoader.reset();
        initialized = false;
    }

    public static void initialize() {
        TigerGlobalConfiguration.initializeWithCliProperties(Map.of());
    }

    public static void initializeWithCliProperties(Map<String, String> additionalProperties) {
        if (initialized) {
            return;
        }
        initialized = true;
        globalConfigurationLoader.initialize();
        globalConfigurationLoader.loadSystemProperties();
        globalConfigurationLoader.loadEnvironmentVariables();
        if (additionalProperties != null) {
            additionalProperties.forEach((key, value) -> TigerGlobalConfiguration.putValue(key, value, SourceType.CLI));
        }
        TigerGlobalConfiguration.addFreePortVariables();
        TigerGlobalConfiguration.readYamlFiles();
        TigerGlobalConfiguration.readAdditionalYamlFiles();
    }

    private static void addFreePortVariables() {
        for (int i = 0; i < 256; ++i) {
            try {
                ServerSocket serverSocket = new ServerSocket(0);
                globalConfigurationLoader.putValue("free.port." + i, Integer.toString(serverSocket.getLocalPort()), SourceType.RUNTIME_EXPORT);
                serverSocket.close();
                continue;
            }
            catch (IOException e) {
                throw new TigerConfigurationException("Exception while trying to add free port variables", e);
            }
        }
    }

    public static synchronized String readString(String key) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readString(key);
    }

    public static synchronized String readString(String key, String defaultValue) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readString(key, defaultValue);
    }

    public static synchronized Optional<String> readStringOptional(String key) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readStringOptional(key);
    }

    public static synchronized <T> T instantiateConfigurationBean(Class<T> configurationBeanClass, String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.instantiateConfigurationBean(configurationBeanClass, baseKeys);
    }

    public static synchronized void readFromYaml(String yamlSource, String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.readFromYaml(yamlSource, baseKeys);
    }

    public static synchronized void readFromYaml(String yamlSource, SourceType sourceType, String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.readFromYaml(yamlSource, sourceType, baseKeys);
    }

    public static synchronized boolean readBoolean(String key) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readBoolean(key);
    }

    public static synchronized boolean readBoolean(String key, boolean defaultValue) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readBoolean(key, defaultValue);
    }

    public static synchronized void readTemplates(String templatesYaml, String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.readTemplates(templatesYaml, baseKeys);
    }

    private static void assertGlobalConfigurationIsInitialized() {
        if (!initialized) {
            TigerGlobalConfiguration.initialize();
            initialized = true;
        }
    }

    public static Map<String, String> readMap(String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readMap(baseKeys);
    }

    public static List<AbstractTigerConfigurationSource> listSources() {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.listSources();
    }

    public static void putValue(String key, String value) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.putValue(key, value);
    }

    public static void putValue(String key, Object value) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.putValue(key, value.toString());
    }

    public static void putValue(String key, String value, SourceType sourceType) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.putValue(key, value, sourceType);
    }

    public static void putValue(String key, Object value, SourceType sourceType) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.putValue(key, value.toString(), sourceType);
    }

    public static String resolvePlaceholders(String stringToSubstitute) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return TokenSubstituteHelper.substitute(stringToSubstitute, globalConfigurationLoader);
    }

    public static Optional<Integer> readIntegerOptional(String key) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return TigerGlobalConfiguration.readStringOptional(key).map(Integer::parseInt);
    }

    private static void readYamlFiles() {
        TigerGlobalConfiguration.readStringOptional("TIGER_YAML").ifPresent(s -> globalConfigurationLoader.readFromYaml((String)s, SourceType.TEST_YAML, "tiger"));
        Optional<File> customCfgFile = TigerGlobalConfiguration.readStringOptional("TIGER_TESTENV_CFGFILE").map(File::new);
        if (customCfgFile.isPresent()) {
            if (customCfgFile.get().exists()) {
                TigerGlobalConfiguration.readYamlFile(customCfgFile.get());
                return;
            }
            throw new TigerConfigurationException("Could not find configuration-file '" + customCfgFile.get().getAbsolutePath() + "'.");
        }
        String computerName = TigerGlobalConfiguration.getComputerName();
        Optional<File> cfgFile = Stream.of(TigerGlobalConfiguration.readStringOptional("TIGER_TESTENV_CFGFILE").orElse(null), "tiger-" + computerName + ".yaml", "tiger-" + computerName + ".yml", "tiger.yaml", "tiger.yml").filter(Objects::nonNull).map(File::new).filter(File::exists).findFirst();
        if (cfgFile.isPresent()) {
            TigerGlobalConfiguration.readYamlFile(cfgFile.get());
            return;
        }
        Optional<File> oldCfgFile = Stream.of(TigerGlobalConfiguration.readStringOptional("TIGER_TESTENV_CFGFILE").orElse(null), "tiger-testenv-" + computerName + ".yaml", "tiger-testenv-" + computerName + ".yml", "tiger-testenv.yaml", "tiger-testenv.yml").filter(Objects::nonNull).map(File::new).filter(File::exists).findFirst();
        if (oldCfgFile.isPresent()) {
            log.warn("Older file format detected! Will be deprecated in upcoming versions. Please use tiger.yaml!");
            TigerGlobalConfiguration.readYamlFile(oldCfgFile.get());
            return;
        }
        if (requireTigerYaml) {
            throw new TigerConfigurationException("Could not find configuration-file 'tiger.yaml'.");
        }
    }

    private static void readAdditionalYamlFiles() {
        List<AdditionalYamlProperty> additionalYamls = globalConfigurationLoader.instantiateConfigurationBean(new TypeReference<List<AdditionalYamlProperty>>(){}, "tiger", "additionalYamls");
        for (AdditionalYamlProperty additionalYaml : additionalYamls) {
            TigerGlobalConfiguration.readYamlFile(Optional.ofNullable(additionalYaml.getFilename()).filter(Objects::nonNull).map(File::new).filter(File::exists).orElseThrow(() -> new TigerConfigurationException("Unable to locate file from configuration " + additionalYaml)));
        }
    }

    private static String getComputerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return InetAddress.getLoopbackAddress().getHostName();
        }
    }

    private static void readYamlFile(File file) {
        try {
            log.info("Reading configuration from file '{}'", (Object)file.getAbsolutePath());
            TigerGlobalConfiguration.readFromYaml(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8), "tiger");
        }
        catch (IOException | RuntimeException e) {
            throw new TigerConfigurationException("Error while reading configuration from file '" + file.getAbsolutePath() + "'", e);
        }
    }

    @Generated
    public static boolean isRequireTigerYaml() {
        return requireTigerYaml;
    }

    @Generated
    public static void setRequireTigerYaml(boolean requireTigerYaml) {
        TigerGlobalConfiguration.requireTigerYaml = requireTigerYaml;
    }
}

