/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.banner;

import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.banner.BannerFontMetrics;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class Banner {
    private static Map<Character, List<String>> asciiArt = null;
    private static final Map<String, BannerFontMetrics> configs = new HashMap<String, BannerFontMetrics>();
    private static BannerFontMetrics cfg;

    private Banner() {
    }

    public static void initialize() {
        configs.put("Spliff", new BannerFontMetrics(9, 5, true));
        configs.put("Doom", new BannerFontMetrics(12, 8, true));
        configs.put("Thin", new BannerFontMetrics(6, 6, false));
        configs.put("Straight", new BannerFontMetrics(6, 4, false));
        String font = TigerGlobalConfiguration.readString("TIGER_BANNER_FONT", "Straight");
        cfg = configs.get(font);
        asciiArt = new HashMap<Character, List<String>>();
        List lines = IOUtils.readLines((InputStream)Objects.requireNonNull(Banner.class.getResourceAsStream("/de/gematik/test/tiger/common/banner/ascii-" + font + ".txt")), (Charset)StandardCharsets.UTF_8);
        for (int ascii = 32; ascii <= 252; ++ascii) {
            int i;
            ArrayList<String> linesForChar = new ArrayList<String>();
            int maxWidth = 0;
            for (i = 0; i < cfg.getHeight(); ++i) {
                maxWidth = Math.max(((String)lines.get((ascii - 32 + 1) * cfg.getHeight() + i)).trim().length(), maxWidth);
            }
            if (maxWidth < cfg.getWidth()) {
                ++maxWidth;
            }
            for (i = 0; i < cfg.getHeight(); ++i) {
                String line = (String)lines.get((ascii - 32 + 1) * cfg.getHeight() + i);
                linesForChar.add(line.substring(0, Math.min(maxWidth, line.length())));
            }
            asciiArt.put(Character.valueOf((char)ascii), linesForChar);
        }
    }

    public static String toBannerStr(String msg, String ansiColors) {
        return ansiColors + StringUtils.repeat((char)'=', (int)100) + RbelAnsiColors.RESET + "\n" + Banner.toBannerLines(msg).stream().map(line -> Ansi.colorize(line, ansiColors)).collect(Collectors.joining("\n")) + "\n" + Ansi.colorize(StringUtils.repeat((char)'=', (int)100), ansiColors);
    }

    public static String toTextStr(String msg, String colorName) {
        String ansiColors = RbelAnsiColors.seekColor((String)colorName.toLowerCase()).toString();
        return Ansi.colorize(msg, ansiColors);
    }

    public static String toBannerStrWithCOLOR(String msg, String colorName) {
        String ansiColors = RbelAnsiColors.seekColor((String)colorName.toLowerCase()).toString();
        return Ansi.colorize(StringUtils.repeat((char)'=', (int)100), ansiColors) + "\n" + Banner.toBannerLines(msg).stream().map(line -> Ansi.colorize(line, ansiColors)).collect(Collectors.joining("\n")) + "\n" + Ansi.colorize(StringUtils.repeat((char)'=', (int)100), ansiColors);
    }

    private static List<String> toBannerLines(String msg) {
        if (asciiArt == null) {
            Banner.initialize();
        }
        ArrayList<String> outLines = new ArrayList<String>();
        for (int y = 0; y < cfg.getHeight(); ++y) {
            StringBuilder outLine = new StringBuilder();
            for (int i = 0; i < msg.length(); ++i) {
                char ascii = msg.charAt(i);
                if (asciiArt.get(Character.valueOf(ascii)) == null) {
                    ascii = ' ';
                }
                outLine.append(" ").append(asciiArt.get(Character.valueOf(ascii)).get(y));
            }
            outLines.add(outLine.toString());
        }
        return outLines;
    }

    public static void shout(String msg) {
        Banner.shout(msg, RbelAnsiColors.YELLOW_BOLD.toString());
    }

    public static void shout(String msg, String ansiColors) {
        Banner.toBannerLines(msg).forEach(line -> System.out.println(Ansi.colorize(line, ansiColors)));
    }
}

