/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common;

import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.exceptions.TigerOsException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OsEnvironment {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OsEnvironment.class);

    public static boolean isIPv4(String ipAddress) {
        boolean isIPv4 = false;
        if (ipAddress != null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(ipAddress);
                isIPv4 = inetAddress instanceof Inet4Address && inetAddress.getHostAddress().equals(ipAddress);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return isIPv4;
    }

    public static String getDockerHostIp() {
        String dockerNet;
        if (SystemUtils.IS_OS_LINUX) {
            dockerNet = "docker0";
        } else if (SystemUtils.IS_OS_MAC) {
            dockerNet = "en0";
        } else {
            if (SystemUtils.IS_OS_WINDOWS) {
                log.warn("Docker host IP detection on Windows is not supported at the moment, falling back to default docker host ip 172.17.0.1 - FINGERS CROSSED!");
                return "172.17.0.1";
            }
            throw new TigerOsException("Docker host ip detection is only supported on Linux, Mac, Windows! Your system seems to be reported as " + TigerGlobalConfiguration.readString("os.name"));
        }
        try {
            Optional<ArrayList> optAdresses = Collections.list(NetworkInterface.getNetworkInterfaces()).stream().filter(netint -> netint.getDisplayName().equals(dockerNet)).map(netint -> Collections.list(netint.getInetAddresses())).findAny();
            if (optAdresses.isEmpty()) {
                log.warn("Unable to detect network '" + dockerNet + "' on this host, assuming default value 172.17.0.1");
                try {
                    Collections.list(NetworkInterface.getNetworkInterfaces()).forEach(netinf -> log.warn("Found net interface " + netinf.getDisplayName()));
                }
                catch (SocketException ex) {
                    log.error("Even unable to find any network interface!", (Throwable)ex);
                }
                return "172.17.0.1";
            }
            return optAdresses.get().stream().map(InetAddress::getHostAddress).filter(OsEnvironment::isIPv4).findAny().orElseThrow(() -> new TigerOsException("Docker network has no ipv4 address!"));
        }
        catch (Exception e) {
            try {
                Collections.list(NetworkInterface.getNetworkInterfaces()).forEach(netinf -> log.warn("Found net interface " + netinf.getDisplayName()));
            }
            catch (SocketException ex) {
                log.error("Even unable to find any network interface!", (Throwable)ex);
            }
            throw new TigerOsException("Unable to detect docker network!", e);
        }
    }

    @Generated
    private OsEnvironment() {
    }
}

