/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.pki;

import de.gematik.rbellogger.util.RbelPkiIdentity;
import de.gematik.test.tiger.common.pki.TigerPkiIdentityLoader;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class TigerPkiIdentity
extends RbelPkiIdentity {
    private final List<X509Certificate> certificateChain = new ArrayList<X509Certificate>();

    public TigerPkiIdentity(X509Certificate certificate, PrivateKey privateKey) {
        super(certificate, privateKey, Optional.empty());
    }

    public TigerPkiIdentity(String fileLoadingInformation) {
        TigerPkiIdentity identity = TigerPkiIdentityLoader.loadRbelPkiIdentity(fileLoadingInformation);
        this.setCertificate(identity.getCertificate());
        this.setPrivateKey(identity.getPrivateKey());
        this.setKeyId(identity.getKeyId());
        this.certificateChain.addAll(identity.getCertificateChain());
    }

    public TigerPkiIdentity addCertificateToCertificateChain(X509Certificate newChainCertificate) {
        this.certificateChain.add(newChainCertificate);
        return this;
    }

    public boolean hasValidChainWithRootCa() {
        if (this.getCertificate() == null) {
            return false;
        }
        X509Certificate currentPosition = this.getCertificate();
        for (X509Certificate nextCertificate : this.getCertificateChain()) {
            if (!currentPosition.getIssuerDN().equals(nextCertificate.getSubjectDN())) {
                return false;
            }
            currentPosition = nextCertificate;
        }
        return currentPosition.getSubjectDN().equals(currentPosition.getIssuerDN());
    }

    @Generated
    public List<X509Certificate> getCertificateChain() {
        return this.certificateChain;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerPkiIdentity)) {
            return false;
        }
        TigerPkiIdentity other = (TigerPkiIdentity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<X509Certificate> this$certificateChain = this.getCertificateChain();
        List<X509Certificate> other$certificateChain = other.getCertificateChain();
        return !(this$certificateChain == null ? other$certificateChain != null : !((Object)this$certificateChain).equals(other$certificateChain));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerPkiIdentity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<X509Certificate> $certificateChain = this.getCertificateChain();
        result = result * 59 + ($certificateChain == null ? 43 : ((Object)$certificateChain).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TigerPkiIdentity(certificateChain=" + this.getCertificateChain() + ")";
    }

    @Generated
    public TigerPkiIdentity() {
    }
}

