/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import de.gematik.test.tiger.common.config.AbstractTigerConfigurationSource;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerConfigurationKeyString;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerTemplateSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerTemplateSource.class);
    private final String templateName;
    private final List<TigerConfigurationKeyString> targetPath;
    private final Map<TigerConfigurationKey, String> values;

    public List<TigerConfigurationKey> applyToAllApplicable(AbstractTigerConfigurationSource tigerConfigurationSource, Map<TigerConfigurationKey, String> finalValues) {
        ArrayList<TigerConfigurationKey> appliedTemplateKeys = new ArrayList<TigerConfigurationKey>();
        HashSet<TigerConfigurationKey> priorKeys = new HashSet<TigerConfigurationKey>(finalValues.keySet());
        tigerConfigurationSource.getValues().entrySet().stream().filter(entry -> ((TigerConfigurationKey)entry.getKey()).size() == this.targetPath.size() + 1 + 1).filter(entry -> ((TigerConfigurationKey)entry.getKey()).subList(0, this.targetPath.size()).equals(this.targetPath)).filter(entry -> ((TigerConfigurationKeyString)((TigerConfigurationKey)entry.getKey()).get(this.targetPath.size() + 1)).getValue().equalsIgnoreCase("template")).filter(entry -> ((String)entry.getValue()).equals(this.templateName)).forEach(templateSelectionEntry -> {
            for (Map.Entry<TigerConfigurationKey, String> valueEntry : this.values.entrySet()) {
                TigerConfigurationKey newKey = new TigerConfigurationKey();
                newKey.addAll(this.targetPath);
                newKey.add((TigerConfigurationKeyString)((TigerConfigurationKey)templateSelectionEntry.getKey()).get(this.targetPath.size()));
                newKey.addAll(valueEntry.getKey());
                if (priorKeys.stream().anyMatch(existingKey -> this.shouldBeReplaced((List<TigerConfigurationKeyString>)existingKey, newKey, this.targetPath)) || finalValues.containsKey(newKey)) continue;
                finalValues.put(newKey, valueEntry.getValue());
            }
            appliedTemplateKeys.add((TigerConfigurationKey)templateSelectionEntry.getKey());
        });
        return appliedTemplateKeys;
    }

    private boolean shouldBeReplaced(List<TigerConfigurationKeyString> existingKey, List<TigerConfigurationKeyString> newKey, List<TigerConfigurationKeyString> basePath) {
        boolean pathContainedNumber = false;
        for (int i = basePath.size() + 1; i < Math.min(existingKey.size(), newKey.size()); ++i) {
            TigerConfigurationKeyString newKeyPart;
            TigerConfigurationKeyString existingKeyPart = existingKey.get(i);
            if (existingKeyPart.equals(newKeyPart = newKey.get(i))) {
                pathContainedNumber |= NumberUtils.isDigits((String)newKeyPart.getValue());
                continue;
            }
            if (pathContainedNumber || NumberUtils.isDigits((String)newKeyPart.getValue())) {
                log.info("Skipping {} due to {}", (Object)newKey.stream().map(TigerConfigurationKeyString::getValue).collect(Collectors.joining(",")), (Object)existingKey.stream().map(TigerConfigurationKeyString::getValue).collect(Collectors.joining(",")));
                return true;
            }
            return false;
        }
        return false;
    }

    @Generated
    public static TigerTemplateSourceBuilder builder() {
        return new TigerTemplateSourceBuilder();
    }

    @ConstructorProperties(value={"templateName", "targetPath", "values"})
    @Generated
    public TigerTemplateSource(String templateName, List<TigerConfigurationKeyString> targetPath, Map<TigerConfigurationKey, String> values) {
        this.templateName = templateName;
        this.targetPath = targetPath;
        this.values = values;
    }

    @Generated
    public static class TigerTemplateSourceBuilder {
        @Generated
        private String templateName;
        @Generated
        private List<TigerConfigurationKeyString> targetPath;
        @Generated
        private Map<TigerConfigurationKey, String> values;

        @Generated
        TigerTemplateSourceBuilder() {
        }

        @Generated
        public TigerTemplateSourceBuilder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Generated
        public TigerTemplateSourceBuilder targetPath(List<TigerConfigurationKeyString> targetPath) {
            this.targetPath = targetPath;
            return this;
        }

        @Generated
        public TigerTemplateSourceBuilder values(Map<TigerConfigurationKey, String> values) {
            this.values = values;
            return this;
        }

        @Generated
        public TigerTemplateSource build() {
            return new TigerTemplateSource(this.templateName, this.targetPath, this.values);
        }

        @Generated
        public String toString() {
            return "TigerTemplateSource.TigerTemplateSourceBuilder(templateName=" + this.templateName + ", targetPath=" + this.targetPath + ", values=" + this.values + ")";
        }
    }
}

