/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import de.gematik.test.tiger.common.TokenSubstituteHelper;
import de.gematik.test.tiger.common.config.AbstractTigerConfigurationSource;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerConfigurationLoader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerGlobalConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerGlobalConfiguration.class);
    private static TigerConfigurationLoader globalConfigurationLoader = new TigerConfigurationLoader();
    private static boolean initialized = false;

    public static synchronized void reset() {
        globalConfigurationLoader.reset();
        initialized = false;
    }

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        globalConfigurationLoader.initialize();
        globalConfigurationLoader.loadSystemProperties();
        globalConfigurationLoader.loadEnvironmentVariables();
    }

    public static synchronized String readString(String key) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readString(key);
    }

    public static synchronized String readString(String key, String defaultValue) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readString(key, defaultValue);
    }

    public static synchronized Optional<String> readStringOptional(String key) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readStringOptional(key);
    }

    public static synchronized <T> T instantiateConfigurationBean(Class<T> configurationBeanClass, String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.instantiateConfigurationBean(configurationBeanClass, baseKeys);
    }

    public static synchronized void readFromYaml(String yamlSource, String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.readFromYaml(yamlSource, baseKeys);
    }

    public static synchronized boolean readBoolean(String key) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readBoolean(key);
    }

    public static synchronized boolean readBoolean(String key, boolean defaultValue) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readBoolean(key, defaultValue);
    }

    public static synchronized void readTemplates(String templatesYaml, String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.readTemplates(templatesYaml, baseKeys);
    }

    private static void assertGlobalConfigurationIsInitialized() {
        if (!initialized) {
            TigerGlobalConfiguration.initialize();
            initialized = true;
        }
    }

    public static Map<String, String> readMap(String ... baseKeys) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.readMap(baseKeys);
    }

    public static List<AbstractTigerConfigurationSource> listSources() {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return globalConfigurationLoader.listSources();
    }

    public static void putValue(String key, String value) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.putValue(key, value);
    }

    public static void putValue(String key, Object value) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.putValue(key, value.toString());
    }

    public static void putValue(String key, String value, SourceType sourceType) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.putValue(key, value, sourceType);
    }

    public static void putValue(String key, Object value, SourceType sourceType) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        globalConfigurationLoader.putValue(key, value.toString(), sourceType);
    }

    public static String resolvePlaceholders(String stringToSubstitute) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return TokenSubstituteHelper.substitute(stringToSubstitute, globalConfigurationLoader);
    }

    public static Optional<Integer> readIntegerOptional(String key) {
        TigerGlobalConfiguration.assertGlobalConfigurationIsInitialized();
        return TigerGlobalConfiguration.readStringOptional(key).map(Integer::parseInt);
    }
}

