/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractInputStreamAssert;
import org.assertj.core.api.Assertions;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.parser.ParserException;

public class TigerConfigurationHelper<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerConfigurationHelper.class);
    private static final ObjectMapper objMapper = new ObjectMapper();

    public T yamlToConfig(String yamlPath, String product, Class<T> cfgClazz) {
        return this.yamlReadOverwriteToConfig(yamlPath, product, cfgClazz);
    }

    public T yamlReadOverwriteToConfig(String yamlPath, String product, Class<T> cfgClazz) {
        try {
            JSONObject json = TigerConfigurationHelper.yamlToJson(yamlPath);
            TigerConfigurationHelper.overwriteWithSysPropsAndEnvVars(product.toUpperCase(), product, json);
            return (T)objMapper.readValue(json.toString(), cfgClazz);
        }
        catch (JsonProcessingException e) {
            throw new TigerConfigurationException("Unable to convert YAML content to JSON!", e);
        }
    }

    public static JSONObject yamlToJson(String yamlPath) {
        Yaml yaml = new Yaml((BaseConstructor)new DuplicateMapKeysForbiddenConstructor());
        try {
            Map map = (Map)yaml.load(IOUtils.toString((URI)Path.of(yamlPath, new String[0]).toUri(), (Charset)StandardCharsets.UTF_8));
            return new JSONObject(map);
        }
        catch (IOException e) {
            throw new TigerConfigurationException("Unable to read YAML file '" + yamlPath + "'!", e);
        }
    }

    public static JSONObject yamlStringToJson(String yamlStr) {
        Yaml yaml = new Yaml((BaseConstructor)new DuplicateMapKeysForbiddenConstructor());
        Map map = (Map)yaml.load(yamlStr);
        return new JSONObject(map);
    }

    public static JSONObject yamlConfigReadOverwriteToJson(String yamlBaseFilename, String product) {
        String yamlStr;
        File cfgFile = Path.of("config", product, yamlBaseFilename).toFile();
        if (cfgFile.canRead()) {
            try {
                yamlStr = IOUtils.toString((URI)cfgFile.toURI(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new TigerConfigurationException("Failed to read YAML file " + cfgFile.getAbsolutePath() + "!", e);
            }
        }
        try (InputStream is = TigerConfigurationHelper.class.getResourceAsStream("/config/" + product + "/" + yamlBaseFilename);){
            ((AbstractInputStreamAssert)Assertions.assertThat((InputStream)is).withFailMessage("Configuration file '" + cfgFile.getAbsolutePath() + "' neither found in file system nor in classpath!", new Object[0])).isNotNull();
            yamlStr = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new TigerConfigurationException("Failed to read YAML from class path '/config/" + product + "/" + yamlBaseFilename + "' !", e);
        }
        JSONObject json = TigerConfigurationHelper.yamlStringToJson(yamlStr);
        TigerConfigurationHelper.overwriteWithSysPropsAndEnvVars(product.toUpperCase(), product, json);
        return json;
    }

    public T jsonToConfig(String jsonFile, Class<T> cfgClazz) {
        try {
            return (T)objMapper.readValue(IOUtils.toString((URI)Path.of(jsonFile, new String[0]).toUri(), (Charset)StandardCharsets.UTF_8), cfgClazz);
        }
        catch (IOException e) {
            throw new TigerConfigurationException("Failed to convert given JSON file '" + jsonFile + "' to config object of class " + cfgClazz.getName() + "!", e);
        }
    }

    public T jsonStringToConfig(String jsonStr, Class<T> cfgClazz) {
        try {
            return (T)objMapper.readValue(jsonStr, cfgClazz);
        }
        catch (JsonProcessingException e) {
            throw new TigerConfigurationException("Failed to convert given JSON string to config object of class " + cfgClazz.getName() + "!", e);
        }
    }

    public static String toJson(Object cfg) {
        try {
            return objMapper.writerWithDefaultPrettyPrinter().writeValueAsString(cfg);
        }
        catch (JsonProcessingException e) {
            throw new TigerConfigurationException("Failed to convert given object to JSON!", e);
        }
    }

    public static String toYaml(Object cfg) {
        Yaml yaml = new Yaml((BaseConstructor)new DuplicateMapKeysForbiddenConstructor());
        return yaml.dump(cfg);
    }

    public static void overwriteWithSysPropsAndEnvVars(String rootEnv, String rootProps, JSONObject json) {
        json.keys().forEachRemaining(key -> {
            Object obj = json.get(key);
            if (obj instanceof JSONObject) {
                TigerConfigurationHelper.overwriteWithSysPropsAndEnvVars(rootEnv + "_" + key.toUpperCase(), rootProps + "." + key, (JSONObject)obj);
            } else if (obj instanceof JSONArray) {
                TigerConfigurationHelper.overwriteWithSysPropsAndEnvVars(rootEnv + "_" + key.toUpperCase(), rootProps + "." + key, (JSONArray)obj);
            } else {
                log.info("checking for env " + rootEnv + "_" + key.toUpperCase() + ":" + obj);
                String value = System.getProperty(rootProps + "." + key, System.getenv(rootEnv + "_" + key.toUpperCase()));
                if (value != null) {
                    log.info("modifying " + rootEnv + "_" + key.toUpperCase() + ":" + obj + " with " + value);
                    json.put(key, (Object)value);
                }
            }
        });
    }

    public static void applyTemplate(JSONArray cfgArray, String templateKey, JSONArray templates, String templateIdKey) {
        for (int i = 0; i < cfgArray.length(); ++i) {
            JSONObject json = cfgArray.getJSONObject(i);
            if (!json.has(templateKey)) continue;
            TigerConfigurationHelper.lookupAndApplyTemplate(json, templateKey, templates, templateIdKey);
        }
    }

    public static void applyTemplate(JSONObject cfgMap, String templateKey, JSONArray templates, String templateIdKey) {
        for (String objectKey : cfgMap.keySet()) {
            JSONObject json = cfgMap.getJSONObject(objectKey);
            if (!json.has(templateKey)) continue;
            TigerConfigurationHelper.lookupAndApplyTemplate(json, templateKey, templates, templateIdKey);
        }
    }

    private static void lookupAndApplyTemplate(JSONObject json, String templateKey, JSONArray templates, String templateIdKey) {
        String templateId = json.getString(templateKey);
        boolean foundTemplate = false;
        for (int j = 0; j < templates.length(); ++j) {
            JSONObject jsonTemplate = templates.getJSONObject(j);
            if (!jsonTemplate.getString(templateIdKey).equals(templateId)) continue;
            jsonTemplate.keySet().stream().filter(key -> jsonTemplate.get(key) != null).filter(key -> jsonTemplate.get(key) instanceof JSONArray).filter(key -> !jsonTemplate.getJSONArray(key).isEmpty()).filter(key -> !json.has(key) || json.get(key) == null || json.getJSONArray(key).isEmpty()).forEach(key -> json.put(key, (Object)new JSONArray(jsonTemplate.getJSONArray(key))));
            jsonTemplate.keySet().stream().filter(key -> jsonTemplate.get(key) != null).filter(key -> !(jsonTemplate.get(key) instanceof JSONArray)).filter(key -> !json.has(key) || json.get(key) == null).forEach(key -> json.put(key, jsonTemplate.get(key)));
            foundTemplate = true;
        }
        if (!foundTemplate) {
            throw new TigerConfigurationException("Unable to locate template '" + templateId + "'");
        }
    }

    private static void overwriteWithSysPropsAndEnvVars(String rootEnv, String rootProps, JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object obj = jsonArray.get(i);
            if (obj instanceof JSONObject) {
                TigerConfigurationHelper.overwriteWithSysPropsAndEnvVars(rootEnv + "_" + i, rootProps + "." + i, (JSONObject)obj);
                continue;
            }
            if (obj instanceof JSONArray) {
                TigerConfigurationHelper.overwriteWithSysPropsAndEnvVars(rootEnv + "_" + i, rootProps + "." + i, (JSONArray)obj);
                continue;
            }
            log.info("checking for env " + rootEnv + "_" + i + ":" + obj);
            String value = System.getProperty(rootProps + "." + i, System.getenv(rootEnv + "_" + i));
            if (value == null) continue;
            log.info("modifying " + rootEnv + "_" + i + ":" + obj + " with " + value);
            jsonArray.put(i, (Object)value);
        }
    }

    private static class DuplicateMapKeysForbiddenConstructor
    extends SafeConstructor {
        private DuplicateMapKeysForbiddenConstructor() {
        }

        protected Map<Object, Object> constructMapping(MappingNode node) {
            try {
                List keys = node.getValue().stream().map(v -> ((ScalarNode)v.getKeyNode()).getValue()).collect(Collectors.toList());
                Set duplicates = this.findDuplicates(keys);
                if (!duplicates.isEmpty()) {
                    throw new TigerConfigurationException("Duplicate keys in yaml file ('" + String.join((CharSequence)",", duplicates) + "')!");
                }
            }
            catch (Exception e) {
                throw new TigerConfigurationException("Duplicate keys in yaml file!", e);
            }
            try {
                return super.constructMapping(node);
            }
            catch (IllegalStateException e) {
                throw new ParserException("while parsing MappingNode", node.getStartMark(), e.getMessage(), node.getEndMark());
            }
        }

        private <T> Set<T> findDuplicates(Collection<T> collection) {
            HashSet uniques = new HashSet();
            return collection.stream().filter(e -> !uniques.add(e)).collect(Collectors.toSet());
        }
    }
}

