/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.pki;

import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import org.apache.commons.lang3.NotImplementedException;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class KeyMgr {
    private static final String BEGINPUBKEY_STR = "-----BEGIN PUBLIC KEY-----";
    private static final BouncyCastleProvider BOUNCY_CASTLE_PROVIDER = new BouncyCastleProvider();

    private KeyMgr() {
    }

    public static Key readKeyFromPem(String pem) {
        if (pem.contains(BEGINPUBKEY_STR)) {
            throw new NotImplementedException("Future me - Public keys from PEM is currently not implemented!");
        }
        return KeyMgr.readPrivateKeyFromPem(pem);
    }

    public static Certificate readCertificateFromPem(String pem) {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509", (Provider)BOUNCY_CASTLE_PROVIDER);
        ByteArrayInputStream in = new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8));
        return certFactory.generateCertificate(in);
    }

    public static Key readPrivateKeyFromPem(String pem) {
        PEMParser pemParser = new PEMParser((Reader)new StringReader(pem));
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        return converter.getPrivateKey(PrivateKeyInfo.getInstance((Object)pemParser.readObject()));
    }
}

