/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.context;

import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.assertj.core.api.AbstractInputStreamAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

public abstract class ThreadSafeDomainContextProvider {
    protected String domain = "default";

    public abstract Map<String, Object> getContext();

    public abstract Map<String, Object> getContext(String var1);

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String d) {
        Assertions.assertThat((String)d).isNotBlank();
        this.domain = d;
        this.getContext();
    }

    public String getString(String key) {
        Map<String, Object> ctxt = this.getContext();
        Assertions.assertThat(ctxt).containsKey((Object)key);
        Object value = ctxt.get(key);
        return value == null ? null : value.toString();
    }

    public String putString(String key, String value) {
        Object o = this.getContext().put(key, value);
        return o == null ? null : o.toString();
    }

    public void copyAllToDomain(String otherDomain) {
        this.getContext(otherDomain).putAll(this.getContext());
    }

    public Object copyToDomain(String otherDomain, String key) {
        return this.getContext(otherDomain).put(key, this.getContext().get(key));
    }

    public Map<String, Object> getObjectMapCopy(String key) {
        Assertions.assertThat((Object)this.getContext().get(key)).isInstanceOf(Map.class);
        return new HashMap<String, Object>((Map)this.getContext().get(key));
    }

    public void assertRegexMatches(String key, String regex) {
        Map<String, Object> ctxt = this.getContext();
        if (regex == null || "$NULL".equals(regex)) {
            Assertions.assertThat(ctxt).containsKey((Object)key);
            Assertions.assertThat((Object)ctxt.get(key)).isNull();
        } else if ("$DOESNOTEXIST".equals(regex)) {
            Assertions.assertThat(ctxt).doesNotContainKey((Object)key);
        } else {
            Assertions.assertThat(ctxt).containsKey((Object)key);
            String value = Optional.ofNullable(ctxt.get(key)).map(Object::toString).orElse(null);
            if (!Objects.equals(value, regex)) {
                Assertions.assertThat((String)value).matches((CharSequence)regex);
            }
        }
    }

    public void remove(String key) {
        Assertions.assertThat(this.getContext()).containsKey((Object)key);
        this.getContext().remove(key);
    }

    public void flipBit(int bitidx, String key) {
        int shift;
        int idx;
        Assertions.assertThat(this.getContext()).containsKey((Object)key);
        ((ObjectAssert)Assertions.assertThat((Object)this.getContext().get(key)).withFailMessage("Value for '" + key + "' in context is null!", new Object[0])).isNotNull();
        String value = this.getContext().get(key).toString();
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        if (bitidx < 0) {
            idx = bytes.length - 1 + bitidx / 8;
            shift = -bitidx % 8;
        } else {
            idx = bitidx / 8;
            shift = 8 - bitidx % 8;
        }
        int n = idx;
        bytes[n] = (byte)(bytes[n] ^ (byte)(1 << shift));
        String flippedValue = new String(bytes);
        Assertions.assertThat((String)flippedValue).isNotEqualTo((Object)value);
        this.getContext().put(key, flippedValue);
    }

    protected String getId() {
        return Thread.currentThread().getId() + this.domain;
    }

    protected String getId(String otherDomain) {
        return Thread.currentThread().getId() + otherDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertPropFileMatches(String propFileName) {
        try (InputStream in = null;){
            in = propFileName.startsWith("classpath:") ? this.getClass().getResourceAsStream(propFileName.substring("classpath:".length())) : new FileInputStream(propFileName);
            ((AbstractInputStreamAssert)Assertions.assertThat((InputStream)in).withFailMessage("Unable to access properties file '" + propFileName + "'", new Object[0])).isNotNull();
            Properties p = new Properties();
            p.load(in);
            this.getContext().keySet().forEach(key -> Assertions.assertThat((String)this.getContext().get(key).toString()).isEqualTo(p.getProperty((String)key)));
        }
    }
}

