/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.common.banner;

import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.OsEnvironment;
import de.gematik.test.tiger.common.banner.BannerConfig;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class Banner {
    private static Map<Character, List<String>> asciiArt = null;
    private static final Map<String, BannerConfig> configs = new HashMap<String, BannerConfig>();
    private static BannerConfig cfg;

    private Banner() {
    }

    private static void initialize() {
        configs.put("Spliff", new BannerConfig(9, 5, true));
        configs.put("Doom", new BannerConfig(12, 8, true));
        configs.put("Thin", new BannerConfig(6, 6, false));
        configs.put("Straight", new BannerConfig(6, 4, false));
        String font = OsEnvironment.getAsString("TIGER_BANNER_FONT", "Straight");
        cfg = configs.get(font);
        asciiArt = new HashMap<Character, List<String>>();
        List lines = IOUtils.readLines((InputStream)Objects.requireNonNull(Banner.class.getResourceAsStream("/de/gematik/test/tiger/common/banner/ascii-" + font + ".txt")), (Charset)StandardCharsets.UTF_8);
        for (int ascii = 32; ascii < 252; ++ascii) {
            int i;
            ArrayList<String> linesForChar = new ArrayList<String>();
            int maxWidth = 0;
            for (i = 0; i < cfg.getHeight(); ++i) {
                maxWidth = Math.max(((String)lines.get((ascii - 32 + 1) * cfg.getHeight() + i)).trim().length(), maxWidth);
            }
            if (maxWidth < cfg.getWidth()) {
                ++maxWidth;
            }
            for (i = 0; i < cfg.getHeight(); ++i) {
                String line = (String)lines.get((ascii - 32 + 1) * cfg.getHeight() + i);
                linesForChar.add(line.substring(0, Math.min(maxWidth, line.length())));
            }
            asciiArt.put(Character.valueOf((char)ascii), linesForChar);
        }
    }

    public static String toBannerStr(String msg, String ansiColors) {
        return ansiColors + StringUtils.repeat((char)'=', (int)100) + "\u001b[0m\n" + Banner.toBannerLines(msg).stream().map(line -> ansiColors + line + "\u001b[0m").collect(Collectors.joining("\n")) + "\n" + ansiColors + StringUtils.repeat((char)'=', (int)100) + "\u001b[0m";
    }

    public static String toBannerStrWithCOLOR(String msg, String colorName) {
        try {
            String ansiColors = (String)Ansi.class.getDeclaredField(colorName).get(null);
            return ansiColors + StringUtils.repeat((char)'=', (int)100) + "\u001b[0m\n" + Banner.toBannerLines(msg).stream().map(line -> ansiColors + line + "\u001b[0m").collect(Collectors.joining("\n")) + "\n" + ansiColors + StringUtils.repeat((char)'=', (int)100) + "\u001b[0m";
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new AssertionError("Unknown color name '" + colorName + "'!", e);
        }
    }

    private static List<String> toBannerLines(String msg) {
        if (asciiArt == null) {
            Banner.initialize();
        }
        ArrayList<String> outLines = new ArrayList<String>();
        for (int y = 0; y < cfg.getHeight(); ++y) {
            StringBuilder outLine = new StringBuilder();
            for (int i = 0; i < msg.length(); ++i) {
                char ascii = msg.charAt(i);
                if (asciiArt.get(Character.valueOf(ascii)) == null) {
                    ascii = ' ';
                }
                outLine.append(" ").append(asciiArt.get(Character.valueOf(ascii)).get(y));
            }
            outLines.add(outLine.toString());
        }
        return outLines;
    }

    public static void shout(String msg) {
        Banner.shout(msg, "\u001b[1m\u001b[33m");
    }

    public static void shout(String msg, String ansiColors) {
        Banner.toBannerLines(msg).forEach(line -> System.out.println(ansiColors + line + "\u001b[0m"));
    }
}

