/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.admin.helper.exceptions;

import de.gematik.test.tiger.common.config.TigerConfigurationException;
import java.io.IOException;
import java.util.ArrayList;
import lombok.Generated;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;

@ControllerAdvice
public class ExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandler.class);

    @org.springframework.web.bind.annotation.ExceptionHandler(value={IOException.class})
    public ResponseEntity<String> handleIOException(IOException ioException) {
        log.error("Handling IOException", (Throwable)ioException);
        return new ResponseEntity((Object)this.collectCauses((Throwable)ioException), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @org.springframework.web.bind.annotation.ExceptionHandler(value={TigerConfigurationException.class})
    public ResponseEntity<String> handleIOException(TigerConfigurationException cfgException) {
        log.error("Handling TigerConfigurationException", (Throwable)cfgException);
        return new ResponseEntity((Object)this.collectCauses((Throwable)cfgException), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private String collectCauses(Throwable e) {
        JSONObject json = new JSONObject();
        json.put("mainCause", (Object)e.getMessage());
        ArrayList<String> causes = new ArrayList<String>();
        while (e.getCause() != null) {
            e = e.getCause();
            causes.add(e.getMessage());
        }
        json.put("causes", causes);
        return json.toString();
    }
}

