/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.admin.controller;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerConfigurationHelper;
import de.gematik.test.tiger.common.config.TigerConfigurationLoader;
import de.gematik.test.tiger.common.config.TigerProperties;
import de.gematik.test.tiger.common.data.config.CfgTemplate;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.Configuration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

@Controller
public class TigerAdminUiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerAdminUiController.class);
    private TigerProperties tigerProperties = new TigerProperties();
    static String templatesYaml;

    @GetMapping(value={"/"})
    public String getStartPage(Model model) {
        model.addAttribute("tigerVersion", (Object)this.tigerProperties.getFullBuildVersion());
        return "adminui";
    }

    @GetMapping(value={"/tiger_user_manual.html"}, produces={"text/html"})
    @ResponseBody
    public String getManualPage() {
        try {
            return IOUtils.resourceToString((String)"/static/manual/tiger_user_manual.html", (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new TigerConfigurationException("Unable to read user manual from classpath resources!", (Throwable)e);
        }
    }

    @GetMapping(value={"media/{mediafile}.svg"}, produces={"image/svg+xml"})
    public ResponseEntity<byte[]> getManualPageMediaSVG(@PathVariable(value="mediafile") String mediaFile) throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("/static/manual/media/" + mediaFile + ".svg");){
            if (is == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "media file " + mediaFile + " not found");
            }
            ResponseEntity responseEntity = new ResponseEntity((Object)IOUtils.toByteArray((InputStream)is), HttpStatus.OK);
            return responseEntity;
        }
    }

    @GetMapping(value={"{svgfile}.svg"}, produces={"image/svg+xml"})
    public ResponseEntity<byte[]> getManualPageSVG(@PathVariable(value="svgfile") String mediaFile) throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("/static/manual/" + mediaFile + ".svg");){
            if (is == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "media file " + mediaFile + " not found");
            }
            ResponseEntity responseEntity = new ResponseEntity((Object)IOUtils.toByteArray((InputStream)is), HttpStatus.OK);
            return responseEntity;
        }
    }

    @GetMapping(value={"/media/{mediafile}.png"}, produces={"image/png"})
    public ResponseEntity<byte[]> getManualPageMediaPNG(@PathVariable(value="mediafile") String mediaFile) throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("/static/manual/media/" + mediaFile + ".png");){
            if (is == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "media file " + mediaFile + " not found");
            }
            ResponseEntity responseEntity = new ResponseEntity((Object)IOUtils.toByteArray((InputStream)is), HttpStatus.OK);
            return responseEntity;
        }
    }

    @GetMapping(value={"/examples/{examplefile}"})
    public ResponseEntity<byte[]> getManualPageExampleFile(@PathVariable(value="examplefile") String exampleFile) throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("/static/manual/examples/" + exampleFile);){
            if (is == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Example file " + exampleFile + " not found");
            }
            ResponseEntity responseEntity = new ResponseEntity((Object)IOUtils.toByteArray((InputStream)is), HttpStatus.OK);
            return responseEntity;
        }
    }

    @GetMapping(value={"/openYamlFile"}, produces={"application/json"})
    @ResponseBody
    public Configuration openYamlFile(@RequestParam(value="cfgfile") String file) throws IOException {
        try {
            this.loadTemplates();
            String yamlString = IOUtils.toString((URI)new File(file).toURI(), (Charset)StandardCharsets.UTF_8);
            TigerConfigurationLoader configurationLoader = new TigerConfigurationLoader();
            configurationLoader.readTemplates(templatesYaml, new String[]{"tiger", "servers"});
            configurationLoader.readFromYaml(yamlString, new String[]{"tiger"});
            return configurationLoader.instantiateConfigurationBean(Configuration.class, new String[]{"tiger"}).orElseGet(Configuration::new);
        }
        catch (Exception e) {
            throw new TigerConfigurationException("Unable to load testenv yaml file", (Throwable)e);
        }
    }

    @GetMapping(value={"/getTemplates"}, produces={"application/json"})
    @ResponseBody
    public String getTemplates() {
        try {
            JSONObject jsonTemplate = TigerConfigurationHelper.yamlStringToJson((String)IOUtils.toString((URI)Objects.requireNonNull(TigerTestEnvMgr.class.getResource("templates.yaml")).toURI(), (Charset)StandardCharsets.UTF_8));
            return jsonTemplate.toString();
        }
        catch (Exception e) {
            throw new TigerConfigurationException("Unable to read templates from classpath resources!", (Throwable)e);
        }
    }

    @GetMapping(value={"/getConfigScheme"}, produces={"application/json"})
    @ResponseBody
    public String getConfigScheme() {
        try {
            JacksonModule module = new JacksonModule();
            SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_7, OptionPreset.PLAIN_JSON).with((Module)module);
            configBuilder.forFields().withDefaultResolver(field -> {
                MethodScope getter;
                Class declaringClass = field.getDeclaringType().getErasedType();
                if (!field.isFakeContainerItemScope() && declaringClass.getName().startsWith("de.gematik.test") && (getter = field.findGetter()) != null) {
                    try {
                        return ((Method)getter.getRawMember()).invoke(declaringClass.getConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]);
                    }
                    catch (Exception ex) {
                        throw new TigerConfigurationException("Unable to create instance for class " + declaringClass.getName(), (Throwable)ex);
                    }
                }
                return null;
            });
            SchemaGeneratorConfig config = configBuilder.build();
            SchemaGenerator generator = new SchemaGenerator(config);
            ObjectNode jsonSchema = generator.generateSchema(CfgTemplate.class, new Type[0]);
            return jsonSchema.toString();
        }
        catch (Exception e) {
            throw new TigerConfigurationException("Unable to read templates from classpath resources!", (Throwable)e);
        }
    }

    @PostMapping(value={"/saveYamlFile"}, produces={"application/json"})
    @ResponseBody
    public String saveYamlFile(@RequestBody String jsonStr) {
        JSONObject json = new JSONObject(jsonStr);
        File cfgFile = new File(json.getString("folder") + File.separatorChar + json.getString("file"));
        try {
            DumperOptions options = new DumperOptions();
            options.setIndent(2);
            options.setPrettyFlow(true);
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml yaml = new Yaml(options);
            FileUtils.writeStringToFile((File)cfgFile, (String)yaml.dump(yaml.load(json.getJSONObject("config").toString(4))), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new TigerConfigurationException("Unable to save configuration to file " + cfgFile.getAbsolutePath());
        }
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put("state", (Object)"OK");
        return jsonResponse.toString();
    }

    private void loadTemplates() {
        if (templatesYaml != null) {
            return;
        }
        URL templatesUrl = TigerTestEnvMgr.class.getResource("templates.yaml");
        try {
            templatesYaml = IOUtils.toString((URI)Objects.requireNonNull(templatesUrl).toURI(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException | URISyntaxException e) {
            throw new TigerConfigurationException("Unable to initialize templates!", (Throwable)e);
        }
    }
}

