/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.admin.controller;

import de.gematik.test.tiger.admin.model.DTOFileNavigation;
import de.gematik.test.tiger.common.config.TigerConfigurationHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class TigerFileNavigatorController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerFileNavigatorController.class);
    @Value(value="#{'${fileNav.extensions:yaml,yml}'.split(',')}")
    private List<String> extensions;

    @GetMapping(value={"/navigator/folder"}, produces={"application/json"})
    @ResponseBody
    public String getFolderInfo(@RequestParam(value="current") String currentFolder) throws IOException {
        File folder = new File(currentFolder);
        if (folder.listFiles() == null) {
            throw new IOException("Invalid folder '" + folder.getAbsolutePath() + "' given!");
        }
        try {
            ArrayList<String> childFolders = new ArrayList<String>();
            ArrayList configFiles = new ArrayList();
            childFolders.add("..");
            Arrays.stream(Objects.requireNonNull(folder.listFiles())).sorted().forEach(file -> {
                if (file.isDirectory()) {
                    childFolders.add(file.getName());
                } else {
                    String extension = StringUtils.substringAfterLast((String)file.getName(), (int)46).toLowerCase();
                    if (this.extensions.contains(extension)) {
                        configFiles.add(file.getName());
                    }
                }
            });
            DTOFileNavigation fileNavDTO = new DTOFileNavigation();
            fileNavDTO.setFolders(childFolders);
            fileNavDTO.setCfgfiles(configFiles);
            fileNavDTO.setCurrent(Path.of(folder.getAbsolutePath(), new String[0]).normalize().toFile().getAbsolutePath());
            fileNavDTO.setRoots(Arrays.stream(File.listRoots()).map(File::getPath).collect(Collectors.toList()));
            return TigerConfigurationHelper.toJson((Object)fileNavDTO);
        }
        catch (Exception e) {
            throw new IOException("Unable to parse folder '" + currentFolder + "'!", e);
        }
    }
}

