/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.admin.controller;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import de.gematik.test.tiger.common.config.CfgTemplate;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerConfigurationHelper;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.Configuration;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class TigerAdminUiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerAdminUiController.class);

    @GetMapping(value={"/"})
    public String getStartPage() {
        return "adminui";
    }

    @GetMapping(value={"/openYamlFile"}, produces={"application/json"})
    @ResponseBody
    public String openYamlFile(@RequestParam(value="cfgfile") String file) throws IOException {
        String yamlString = IOUtils.toString((URI)new File(file).toURI(), (Charset)StandardCharsets.UTF_8);
        JSONObject jsonCfg = TigerConfigurationHelper.yamlStringToJson((String)yamlString);
        Configuration configuration = (Configuration)new TigerConfigurationHelper().jsonStringToConfig(jsonCfg.toString(), Configuration.class);
        return TigerConfigurationHelper.toJson((Object)configuration);
    }

    @GetMapping(value={"/getTemplates"}, produces={"application/json"})
    @ResponseBody
    public String getTemplates() {
        try {
            JSONObject jsonTemplate = TigerConfigurationHelper.yamlStringToJson((String)IOUtils.toString((URI)Objects.requireNonNull(TigerTestEnvMgr.class.getResource("templates.yaml")).toURI(), (Charset)StandardCharsets.UTF_8));
            return jsonTemplate.toString();
        }
        catch (Exception e) {
            throw new TigerConfigurationException("Unable to read templates from classpath resources!", (Throwable)e);
        }
    }

    @GetMapping(value={"/getConfigScheme"}, produces={"application/json"})
    @ResponseBody
    public String getConfigScheme() {
        try {
            JacksonModule module = new JacksonModule();
            SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_7, OptionPreset.PLAIN_JSON).with((Module)module);
            configBuilder.forFields().withDefaultResolver(field -> {
                MethodScope getter;
                Class declaringClass = field.getDeclaringType().getErasedType();
                if (!field.isFakeContainerItemScope() && declaringClass.getName().startsWith("de.gematik.test") && (getter = field.findGetter()) != null) {
                    try {
                        return ((Method)getter.getRawMember()).invoke(declaringClass.getConstructor(new Class[0]).newInstance(new Object[0]), new Object[0]);
                    }
                    catch (Exception ex) {
                        throw new TigerConfigurationException("Unable to create instance for class " + declaringClass.getName(), (Throwable)ex);
                    }
                }
                return null;
            });
            SchemaGeneratorConfig config = configBuilder.build();
            SchemaGenerator generator = new SchemaGenerator(config);
            ObjectNode jsonSchema = generator.generateSchema(CfgTemplate.class, new Type[0]);
            return jsonSchema.toString();
        }
        catch (Exception e) {
            throw new TigerConfigurationException("Unable to read templates from classpath resources!", (Throwable)e);
        }
    }
}

