/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.admin.controller;

import de.gematik.test.tiger.common.config.TigerConfigurationHelper;
import de.gematik.test.tiger.testenvmgr.config.Configuration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class TigerAdminUiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerAdminUiController.class);

    @GetMapping(value={"/start"})
    public String getStartPage() {
        return "startPage";
    }

    @GetMapping(value={"/yml-page"})
    public String getYmlPage() {
        return "ymlPage";
    }

    @PostMapping(value={"/openYamlFile"}, produces={"application/json"})
    @ResponseBody
    public String openYamlFile(@RequestParam(value="fileName") MultipartFile file) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(file.getBytes());
        String yamlString = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        JSONObject jsonCfg = TigerConfigurationHelper.yamlStringToJson((String)yamlString);
        Configuration configuration = (Configuration)new TigerConfigurationHelper().jsonStringToConfig(jsonCfg.toString(), Configuration.class);
        return TigerConfigurationHelper.toJson((Object)configuration.getServers());
    }
}

