/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.admin;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.context.annotation.Bean;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@SpringBootApplication
public class TigerAdminApplication {
    @Autowired
    private ThymeleafProperties properties;

    public static void main(String[] args) {
        SpringApplication.run(TigerAdminApplication.class, (String[])args);
    }

    @Bean
    public ITemplateResolver defaultTemplateResolver() {
        ClassLoaderTemplateResolver resolver;
        String prefix = this.properties.getPrefix();
        if (prefix == null || prefix.startsWith("classpath:")) {
            resolver = new ClassLoaderTemplateResolver();
            prefix = prefix.substring("classpath:".length());
        } else {
            resolver = new FileTemplateResolver();
        }
        resolver.setPrefix(prefix);
        resolver.setCacheable(this.properties.isCache());
        resolver.setSuffix(this.properties.getSuffix());
        resolver.setTemplateMode(this.properties.getMode());
        resolver.setCharacterEncoding(this.properties.getEncoding().toString());
        return resolver;
    }
}

