/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.valuesets;

import de.gematik.bbriccs.fhir.coding.exceptions.InvalidValueSetException;
import de.gematik.test.erezept.fhir.valuesets.StatusCoPayment;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StatusCoPaymentTest {
    StatusCoPaymentTest() {
    }

    @Test
    void shouldParseValidStatusCoPaymentFromCode() {
        List<String> codes = List.of("0", "1", "2");
        List<StatusCoPayment> expectedTypes = List.of(StatusCoPayment.STATUS_0, StatusCoPayment.STATUS_1, StatusCoPayment.STATUS_2);
        for (int i = 0; i < codes.size(); ++i) {
            StatusCoPayment actual = StatusCoPayment.fromCode((String)codes.get(i));
            StatusCoPayment expected = expectedTypes.get(i);
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    void shouldThrowExceptionOnInvalidStatusCoPaymentCodes() {
        List<String> codes = List.of("00", "12", "3", "ABCD", "");
        codes.forEach(code -> Assertions.assertThrows(InvalidValueSetException.class, () -> StatusCoPayment.fromCode((String)code)));
    }
}

