/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.valuesets;

import de.gematik.bbriccs.fhir.coding.exceptions.InvalidValueSetException;
import de.gematik.test.erezept.fhir.valuesets.QualificationType;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class QualificationTypeTest {
    QualificationTypeTest() {
    }

    @Test
    void shouldParseFromCode() {
        Map<String, QualificationType> testdata = Map.of("00", QualificationType.DOCTOR, "01", QualificationType.DENTIST, "02", QualificationType.MIDWIFE, "03", QualificationType.DOCTOR_IN_TRAINING, "04", QualificationType.DOCTOR_AS_REPLACEMENT);
        testdata.forEach((code, expected) -> Assertions.assertEquals((Object)expected, (Object)QualificationType.fromCode((String)code)));
    }

    @Test
    void shouldThrowOnInvalidCode() {
        List<String> codes = List.of("05", "0", "1", "");
        codes.forEach(code -> Assertions.assertThrows(InvalidValueSetException.class, () -> QualificationType.fromCode((String)code)));
    }

    @Test
    void shouldParseFromValidDisplayValues() {
        Map<String, QualificationType> testdata = Map.of("Arzt", QualificationType.DOCTOR, "arzt", QualificationType.DOCTOR, "Zahnarzt", QualificationType.DENTIST, "zahnarzt", QualificationType.DENTIST, "Hebamme", QualificationType.MIDWIFE, "hebamme", QualificationType.MIDWIFE, "Arzt in Weiterbildung", QualificationType.DOCTOR_IN_TRAINING, "arzt in weiterbildung", QualificationType.DOCTOR_IN_TRAINING, "Arzt als Vertreter", QualificationType.DOCTOR_AS_REPLACEMENT, "arzt als vertreter", QualificationType.DOCTOR_AS_REPLACEMENT);
        testdata.forEach((display, expected) -> Assertions.assertEquals((Object)expected, (Object)QualificationType.fromDisplay((String)display)));
    }

    @Test
    void shouldThrowOnInvalidDisplayValues() {
        List<String> displays = List.of("arz", "artz", "Zahnarz", "Hebame", "Arzt in Fortbildung", "Weiterbildung", "Vertreter");
        displays.forEach(display -> Assertions.assertThrows(InvalidValueSetException.class, () -> QualificationType.fromDisplay((String)display)));
    }
}

