/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.valuesets;

import de.gematik.bbriccs.fhir.de.valueset.InsuranceTypeDe;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import de.gematik.test.erezept.fhir.valuesets.PrescriptionFlowType;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class PrescriptionFlowTypeTest {
    PrescriptionFlowTypeTest() {
    }

    @Test
    void shouldCreateFromPrescriptionId() {
        List<PrescriptionFlowType> flowTypes = List.of(PrescriptionFlowType.FLOW_TYPE_160, PrescriptionFlowType.FLOW_TYPE_169, PrescriptionFlowType.FLOW_TYPE_200, PrescriptionFlowType.FLOW_TYPE_209);
        flowTypes.forEach(ft -> {
            PrescriptionId pid = PrescriptionId.random((PrescriptionFlowType)ft);
            PrescriptionFlowType actual = PrescriptionFlowType.fromPrescriptionId((PrescriptionId)pid);
            Assertions.assertEquals((Object)ft, (Object)actual);
            Assertions.assertNotNull((Object)ft.toString());
        });
    }

    @Test
    void shouldDetectDirectAssignments() {
        List.of(PrescriptionFlowType.FLOW_TYPE_169, PrescriptionFlowType.FLOW_TYPE_209).forEach(ft -> Assertions.assertTrue((boolean)ft.isDirectAssignment()));
    }

    @Test
    void shouldDetectGkvTypes() {
        List.of(PrescriptionFlowType.FLOW_TYPE_160, PrescriptionFlowType.FLOW_TYPE_169).forEach(ft -> {
            Assertions.assertTrue((boolean)ft.isGkvType());
            Assertions.assertFalse((boolean)ft.isPkvType());
        });
    }

    @Test
    void shouldDetectPkvTypes() {
        List.of(PrescriptionFlowType.FLOW_TYPE_200, PrescriptionFlowType.FLOW_TYPE_209).forEach(ft -> {
            Assertions.assertTrue((boolean)ft.isPkvType());
            Assertions.assertFalse((boolean)ft.isGkvType());
        });
    }

    @ParameterizedTest(name="#{index} - WorkflowType from InsuranceKind {0} expected to be {1}")
    @MethodSource(value={"defaultPrescriptionFlowTypes"})
    void shouldGenerateFromInsuranceKind(InsuranceTypeDe insuranceKind, PrescriptionFlowType expectation) {
        Assertions.assertEquals((Object)expectation, (Object)PrescriptionFlowType.fromInsuranceKind((InsuranceTypeDe)insuranceKind));
        Assertions.assertEquals((Object)expectation, (Object)PrescriptionFlowType.fromInsuranceKind((InsuranceTypeDe)insuranceKind, (boolean)false));
        Assertions.assertFalse((boolean)PrescriptionFlowType.fromInsuranceKind((InsuranceTypeDe)insuranceKind).isDirectAssignment());
    }

    @ParameterizedTest(name="#{index} - WorkflowType from InsuranceKind {0} expected to be {1}")
    @MethodSource(value={"directAssignmentPrescriptionFlowTypes"})
    void shouldGenerateFromInsuranceKindWithDirectAssignment(InsuranceTypeDe insuranceKind, PrescriptionFlowType expectation) {
        Assertions.assertEquals((Object)expectation, (Object)PrescriptionFlowType.fromInsuranceKind((InsuranceTypeDe)insuranceKind, (boolean)true));
        Assertions.assertTrue((boolean)PrescriptionFlowType.fromInsuranceKind((InsuranceTypeDe)insuranceKind, (boolean)true).isDirectAssignment());
    }

    static Stream<Arguments> defaultPrescriptionFlowTypes() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{InsuranceTypeDe.GKV, PrescriptionFlowType.FLOW_TYPE_160}), Arguments.arguments((Object[])new Object[]{InsuranceTypeDe.PKV, PrescriptionFlowType.FLOW_TYPE_200}), Arguments.arguments((Object[])new Object[]{InsuranceTypeDe.BG, PrescriptionFlowType.FLOW_TYPE_160}));
    }

    static Stream<Arguments> directAssignmentPrescriptionFlowTypes() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{InsuranceTypeDe.GKV, PrescriptionFlowType.FLOW_TYPE_169}), Arguments.arguments((Object[])new Object[]{InsuranceTypeDe.PKV, PrescriptionFlowType.FLOW_TYPE_209}), Arguments.arguments((Object[])new Object[]{InsuranceTypeDe.BG, PrescriptionFlowType.FLOW_TYPE_169}));
    }
}

