/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.valuesets;

import de.gematik.bbriccs.fhir.coding.exceptions.InvalidValueSetException;
import de.gematik.test.erezept.fhir.valuesets.PerformerType;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PerformerTypeTest {
    PerformerTypeTest() {
    }

    @Test
    void fromValidCodes() {
        Map<String, PerformerType> validCodes = Map.of("urn:oid:1.2.276.0.76.4.32", PerformerType.PHARMACIST, "urn:oid:1.2.276.0.76.4.54", PerformerType.PUBLIC_PHARMACY);
        validCodes.forEach((code, expected) -> {
            PerformerType actual = PerformerType.fromCode((String)code);
            Assertions.assertEquals((Object)expected, (Object)actual);
        });
    }

    @Test
    void fromInvalidCode() {
        Assertions.assertThrows(InvalidValueSetException.class, () -> PerformerType.fromCode((String)"invalid"));
    }

    @Test
    void fromDisplays() {
        Map<String, PerformerType> validDisplays = Map.of("Apotheke", PerformerType.PHARMACIST, "\u00d6ffentliche Apotheke", PerformerType.PUBLIC_PHARMACY);
        validDisplays.forEach((code, expected) -> {
            PerformerType actual = PerformerType.fromDisplay((String)code);
            Assertions.assertEquals((Object)expected, (Object)actual);
        });
    }

    @Test
    void fromInvalidDisplay() {
        Assertions.assertThrows(InvalidValueSetException.class, () -> PerformerType.fromDisplay((String)"Zahnarzt"));
    }
}

