/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.valuesets;

import de.gematik.bbriccs.fhir.coding.WithCodeSystem;
import de.gematik.bbriccs.fhir.coding.exceptions.InvalidValueSetException;
import de.gematik.test.erezept.fhir.parser.profiles.systems.ErpWorkflowCodeSystem;
import de.gematik.test.erezept.fhir.valuesets.PayorType;
import java.util.List;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PayorTypeTest {
    PayorTypeTest() {
    }

    @Test
    void shouldParseValidPayorTypesFromCode() {
        List<String> codes = List.of("SKT", "UK");
        List<PayorType> expectedTypes = List.of(PayorType.SKT, PayorType.UK);
        for (int i = 0; i < codes.size(); ++i) {
            PayorType actual = PayorType.fromCode((String)codes.get(i));
            PayorType expected = expectedTypes.get(i);
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    void shouldThrowExceptionOnInvalidPayorTypeCodes() {
        List<String> codes = List.of("KST", "UKK");
        codes.forEach(code -> Assertions.assertThrows(InvalidValueSetException.class, () -> PayorType.fromCode((String)code)));
    }

    @Test
    void shouldParseValidPayorTypesFromDisplay() {
        List<String> displayValues = List.of("Sonstige", "Unfallkassen");
        List<PayorType> expectedTypes = List.of(PayorType.SKT, PayorType.UK);
        for (int i = 0; i < displayValues.size(); ++i) {
            PayorType actual = PayorType.fromDisplay((String)displayValues.get(i));
            PayorType expected = expectedTypes.get(i);
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    void shouldThrowExceptionOnInvalidPayorTypeDisplayValues() {
        List<String> codes = List.of("B\u00fcrdentr\u00e4ger", "Krankenkassen");
        codes.forEach(code -> Assertions.assertThrows(InvalidValueSetException.class, () -> PayorType.fromCode((String)code)));
    }

    @Test
    void shouldEncodePayorTypeCoding() {
        List<PayorType> payorTypes = List.of(PayorType.values());
        payorTypes.forEach(pt -> {
            Coding coding = pt.asCoding();
            Assertions.assertEquals((Object)pt.getCode(), (Object)coding.getCode());
            Assertions.assertEquals((Object)pt.getCodeSystem().getCanonicalUrl(), (Object)coding.getSystem());
        });
    }

    @Test
    void shouldEncodePayorTypeCodingWithCustomCodeSystem() {
        PayorType pt = PayorType.UK;
        Coding coding = pt.asCoding((WithCodeSystem)ErpWorkflowCodeSystem.FLOW_TYPE);
        Assertions.assertEquals((Object)pt.getCode(), (Object)coding.getCode());
        Assertions.assertEquals((Object)ErpWorkflowCodeSystem.FLOW_TYPE.getCanonicalUrl(), (Object)coding.getSystem());
    }

    @Test
    void shouldEncodePayorTypeCodeableConcept() {
        List<PayorType> payorTypes = List.of(PayorType.values());
        payorTypes.forEach(pt -> {
            CodeableConcept codeable = pt.asCodeableConcept();
            Assertions.assertEquals((Object)pt.getCode(), (Object)codeable.getCodingFirstRep().getCode());
            Assertions.assertEquals((Object)pt.getCodeSystem().getCanonicalUrl(), (Object)codeable.getCodingFirstRep().getSystem());
        });
    }
}

