/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.valuesets;

import de.gematik.bbriccs.fhir.coding.exceptions.InvalidValueSetException;
import de.gematik.test.erezept.fhir.valuesets.DocumentType;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DocumentTypeTest {
    DocumentTypeTest() {
    }

    @Test
    void shouldParseValidDocumentTypesFromCode() {
        List<String> codes = List.of("1", "2", "3");
        List<DocumentType> expectedTypes = List.of(DocumentType.PRESCRIPTION, DocumentType.CONFIRMATION, DocumentType.RECEIPT);
        for (int i = 0; i < codes.size(); ++i) {
            DocumentType actual = DocumentType.fromCode((String)codes.get(i));
            DocumentType expected = expectedTypes.get(i);
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    void shouldThrowExceptionOnInvalidDocumentTypeCodes() {
        List<String> codes = List.of("eins", "zwei", "0", "4", "12", "33");
        codes.forEach(code -> Assertions.assertThrows(InvalidValueSetException.class, () -> DocumentType.fromCode((String)code)));
    }
}

