/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.valuesets;

import de.gematik.bbriccs.fhir.coding.exceptions.InvalidValueSetException;
import de.gematik.test.erezept.fhir.valuesets.DeFederalState;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DeFederalStateTest {
    DeFederalStateTest() {
    }

    @Test
    void shouldParseValidFederalStateFromCode() {
        List<String> codes = List.of("DE-BW", "DE-BY", "DE-BE", "DE-BB");
        List<DeFederalState> expectedTypes = List.of(DeFederalState.DE_BW, DeFederalState.DE_BY, DeFederalState.DE_BE, DeFederalState.DE_BB);
        for (int i = 0; i < codes.size(); ++i) {
            DeFederalState actual = DeFederalState.fromCode((String)codes.get(i));
            DeFederalState expected = expectedTypes.get(i);
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    void shouldThrowExceptionOnInvalidFederalStateCodes() {
        List<String> codes = List.of("BW", "ABCD", "DE-BAY");
        codes.forEach(code -> Assertions.assertThrows(InvalidValueSetException.class, () -> DeFederalState.fromCode((String)code)));
    }

    @Test
    void shouldParseValidFederalStateFromDisplay() {
        List<String> displayValues = List.of("Baden-W\u00fcrttemberg", "Hamburg", "Sachsen", "Sachsen-Anhalt", "Niedersachsen");
        List<DeFederalState> expectedTypes = List.of(DeFederalState.DE_BW, DeFederalState.DE_HH, DeFederalState.DE_SN, DeFederalState.DE_ST, DeFederalState.DE_NI);
        for (int i = 0; i < displayValues.size(); ++i) {
            DeFederalState actual = DeFederalState.fromDisplay((String)displayValues.get(i));
            DeFederalState expected = expectedTypes.get(i);
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    void shouldThrowExceptionOnInvalidFederalStateDisplayValues() {
        List<String> codes = List.of("Badenw\u00fcrttemberg", "Mallorca", "ABC", "");
        codes.forEach(code -> Assertions.assertThrows(InvalidValueSetException.class, () -> DeFederalState.fromCode((String)code)));
    }
}

