/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.valuesets;

import de.gematik.bbriccs.fhir.coding.exceptions.InvalidValueSetException;
import de.gematik.test.erezept.fhir.parser.profiles.systems.ErpWorkflowCodeSystem;
import de.gematik.test.erezept.fhir.valuesets.AvailabilityStatus;
import java.util.Arrays;
import java.util.List;
import org.hl7.fhir.r4.model.Coding;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AvailabilityStatusTest {
    AvailabilityStatusTest() {
    }

    @Test
    void shouldBuildCodingWithCustomSystem() {
        Coding coding = AvailabilityStatus.AS_10.asCoding(ErpWorkflowCodeSystem.AVAILABILITY_STATUS_12);
        Assertions.assertEquals((Object)ErpWorkflowCodeSystem.AVAILABILITY_STATUS_12.getCanonicalUrl(), (Object)coding.getSystem());
    }

    @Test
    void shouldBuildCodingWithCustomSystemAndDisplay() {
        Coding coding = AvailabilityStatus.AS_20.asCoding(ErpWorkflowCodeSystem.AVAILABILITY_STATUS_12, true);
        Assertions.assertEquals((Object)ErpWorkflowCodeSystem.AVAILABILITY_STATUS_12.getCanonicalUrl(), (Object)coding.getSystem());
        Assertions.assertNotNull((Object)coding.getDisplay());
        Assertions.assertFalse((boolean)coding.getDisplay().isEmpty());
    }

    @Test
    void shouldParseFromString() {
        List<AvailabilityStatus> values = Arrays.asList(AvailabilityStatus.values());
        values.forEach(v -> Assertions.assertEquals((Object)v, (Object)AvailabilityStatus.fromCode((String)v.getCode())));
    }

    @Test
    void shouldThrowOnInvalidString() {
        Assertions.assertThrows(InvalidValueSetException.class, () -> AvailabilityStatus.fromCode((String)"91"));
    }
}

