/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.values;

import de.gematik.test.erezept.fhir.values.LANR;
import de.gematik.test.erezept.fhir.values.ZANR;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class ZANRTest {
    ZANRTest() {
    }

    @Test
    void testFakerZanrLength() {
        String testNum = ZANR.random().getValue();
        Assertions.assertEquals((int)9, (int)testNum.length());
    }

    @Test
    void testLastToDigits() {
        String testNum = ZANR.random().toString().substring(6, 15);
        String docCategori = testNum.substring(7, 9);
        boolean testresult = docCategori.equals("50") | docCategori.equals("91");
        Assertions.assertTrue((boolean)testresult);
    }

    @Test
    void testRandomFakerZanrRealisticEnd() {
        String testLanr = LANR.random().getValue();
        Assertions.assertDoesNotThrow(() -> Integer.parseInt(testLanr));
    }

    @ParameterizedTest(name="[{index}]: ZANR {0} is valid")
    @ValueSource(strings={"444444401", "444444499", "999999900", "555555560", "000000000", "999999991"})
    void additionalNumbersShouldBeValid(String value) {
        ZANR zanr = new ZANR(value);
        Assertions.assertTrue((boolean)zanr.isValid());
    }
}

