/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.values;

import de.gematik.test.erezept.fhir.parser.profiles.systems.ErpWorkflowNamingSystem;
import de.gematik.test.erezept.fhir.values.TelematikID;
import java.util.InputMismatchException;
import org.hl7.fhir.r4.model.Identifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class TelematikIDTest {
    TelematikIDTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"https://gematik.de/fhir/sid/telematik-id", "https://gematik.de/fhir/NamingSystem/TelematikID"})
    void shouldGenerateFormIdentifier(String system) {
        String value = "123.546.789";
        Identifier identifier = new Identifier();
        identifier.setSystem(system);
        identifier.setValue("123.546.789");
        TelematikID telematikId = TelematikID.from((Identifier)identifier);
        Assertions.assertEquals((Object)"123.546.789", (Object)telematikId.getValue());
        Assertions.assertEquals((Object)system, (Object)((ErpWorkflowNamingSystem)telematikId.getSystem()).getCanonicalUrl());
    }

    @Test
    void shouldThrowFormIdentifierWithWrongNamingSystem() {
        String system = "https://gematik.de/fhir/NamingSystem/Secret";
        String value = "123.546.789";
        Identifier identifier = new Identifier();
        identifier.setSystem("https://gematik.de/fhir/NamingSystem/Secret");
        identifier.setValue("123.546.789");
        Assertions.assertThrows(InputMismatchException.class, () -> TelematikID.from((Identifier)identifier));
    }

    @Test
    void shouldBuildFromString() {
        TelematikID telemId = TelematikID.from((String)"123");
        Assertions.assertEquals((Object)"123", (Object)telemId.getValue());
    }
}

