/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.values;

import de.gematik.test.erezept.fhir.values.PrescriptionId;
import de.gematik.test.erezept.fhir.values.TaskId;
import de.gematik.test.erezept.fhir.valuesets.PrescriptionFlowType;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class TaskIdTest {
    TaskIdTest() {
    }

    @Test
    void shouldGenerateFromPrescriptionId() {
        PrescriptionId pid = PrescriptionId.random();
        TaskId tid = TaskId.from((PrescriptionId)pid);
        Assertions.assertEquals((Object)pid.getValue(), (Object)tid.getValue());
        Assertions.assertEquals((Object)tid, (Object)TaskId.from((String)((String)pid.getValue())));
    }

    @Test
    void shouldToString() {
        TaskId tid = TaskId.from((String)"123");
        Assertions.assertEquals((Object)"123", (Object)tid.toString());
    }

    @Test
    void shouldTranslateToPrescriptionId() {
        TaskId tid = TaskId.from((String)"123");
        PrescriptionId pid = tid.toPrescriptionId();
        Assertions.assertEquals((Object)tid.getValue(), (Object)pid.getValue());
    }

    @ParameterizedTest
    @MethodSource
    void shouldMapToFlowType(TaskId tid, PrescriptionFlowType expected) {
        Assertions.assertEquals((Object)expected, (Object)tid.getFlowType());
    }

    static Stream<Arguments> shouldMapToFlowType() {
        return Stream.of(Arguments.of((Object[])new Object[]{TaskId.from((String)"160.0.0.1"), PrescriptionFlowType.FLOW_TYPE_160}), Arguments.of((Object[])new Object[]{TaskId.from((String)"169.0.0.1"), PrescriptionFlowType.FLOW_TYPE_169}), Arguments.of((Object[])new Object[]{TaskId.from((String)"200.0.0.1"), PrescriptionFlowType.FLOW_TYPE_200}), Arguments.of((Object[])new Object[]{TaskId.from((String)"209.0.0.1"), PrescriptionFlowType.FLOW_TYPE_209}));
    }

    @Test
    void shouldEqualOnSameIds() {
        Assertions.assertEquals((Object)TaskId.from((String)"123"), (Object)TaskId.from((String)"123"));
    }

    @Test
    void shouldNotEqualOnDifferentIds() {
        Assertions.assertNotEquals((Object)TaskId.from((String)"123"), (Object)TaskId.from((String)"456"));
    }

    @Test
    void shouldNotEqualOnNull() {
        Assertions.assertNotEquals(null, (Object)TaskId.from((String)"123"));
    }
}

