/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.values;

import de.gematik.bbriccs.fhir.coding.WithSystem;
import de.gematik.bbriccs.fhir.coding.exceptions.InvalidValueSetException;
import de.gematik.test.erezept.fhir.parser.profiles.systems.ErpWorkflowNamingSystem;
import de.gematik.test.erezept.fhir.values.PrescriptionId;
import de.gematik.test.erezept.fhir.values.TaskId;
import de.gematik.test.erezept.fhir.valuesets.PrescriptionFlowType;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Identifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PrescriptionIdTest {
    PrescriptionIdTest() {
    }

    @Test
    void checkValidPrescriptionId() {
        String id = "160.000.000.000.123.76";
        Assertions.assertTrue((boolean)PrescriptionId.checkId((String)"160.000.000.000.123.76"));
    }

    @Test
    void checkInvalidPrescriptionId() {
        String id = "160.000.000.000.123.77";
        Assertions.assertFalse((boolean)PrescriptionId.checkId((String)"160.000.000.000.123.77"));
    }

    @Test
    void shouldTranslateToTaskId() {
        PrescriptionId pid = PrescriptionId.random();
        TaskId tid = pid.toTaskId();
        Assertions.assertEquals((Object)pid.getValue(), (Object)tid.getValue());
    }

    @Test
    void checkRandomPrescriptionId() {
        for (int i = 0; i < 10; ++i) {
            PrescriptionId r = PrescriptionId.random();
            Assertions.assertTrue((boolean)PrescriptionId.checkId((PrescriptionId)r));
        }
    }

    @Test
    void shouldCreatePrescriptionIdFromString() {
        PrescriptionId p = PrescriptionId.from((String)"123");
        Assertions.assertFalse((boolean)p.check());
    }

    @Test
    void shouldDetectOldPrescriptionId() {
        Identifier identifier = PrescriptionId.random().asIdentifier((WithSystem)ErpWorkflowNamingSystem.PRESCRIPTION_ID);
        Assertions.assertTrue((boolean)PrescriptionId.isPrescriptionId((Identifier)identifier));
    }

    @Test
    void shouldDetectNewPrescriptionId() {
        Identifier identifier = PrescriptionId.random().asIdentifier((WithSystem)ErpWorkflowNamingSystem.PRESCRIPTION_ID_121);
        Assertions.assertTrue((boolean)PrescriptionId.isPrescriptionId((Identifier)identifier));
    }

    @Test
    void shouldGetFlowTypeFromPrescriptionId() {
        Stream.of(PrescriptionFlowType.values()).forEach(ft -> {
            PrescriptionId prescriptionId = PrescriptionId.random((PrescriptionFlowType)ft);
            Assertions.assertEquals((Object)ft, (Object)prescriptionId.getFlowType());
        });
    }

    @Test
    void shouldThrowOnPrescriptionIdOfInvalidFlowType() {
        PrescriptionId prescriptionId = PrescriptionId.from((String)"127.0.0.1");
        Assertions.assertThrows(InvalidValueSetException.class, () -> ((PrescriptionId)prescriptionId).getFlowType());
    }

    @Test
    void shouldCreateFromTaskId() {
        TaskId taskId = TaskId.from((String)"123");
        PrescriptionId prescriptionId = PrescriptionId.from((TaskId)taskId);
        Assertions.assertEquals((Object)"123", (Object)prescriptionId.getValue());
    }

    @Test
    void shouldNotMatchOnMissingSystem() {
        Identifier identifier = new Identifier();
        identifier.setValue("160.000.006.403.515.71");
        Assertions.assertFalse((boolean)PrescriptionId.isPrescriptionId((Identifier)identifier));
    }
}

