/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.values;

import de.gematik.bbriccs.fhir.de.valueset.InsuranceTypeDe;
import de.gematik.test.erezept.fhir.values.BGInsuranceCoverageInfo;
import de.gematik.test.erezept.fhir.values.GkvInsuranceCoverageInfo;
import de.gematik.test.erezept.fhir.values.InsuranceCoverageInfo;
import de.gematik.test.erezept.fhir.values.PkvInsuranceCoverageInfo;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;

class InsuranceCoverageInfoTest {
    InsuranceCoverageInfoTest() {
    }

    static Stream<Arguments> coverageDataImplementors() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{InsuranceTypeDe.PKV, List.of(PkvInsuranceCoverageInfo.values())}), Arguments.arguments((Object[])new Object[]{InsuranceTypeDe.GKV, List.of(GkvInsuranceCoverageInfo.values())}), Arguments.arguments((Object[])new Object[]{InsuranceTypeDe.BG, List.of(BGInsuranceCoverageInfo.values())}));
    }

    @Test
    void shouldProvidePkvName() {
        Assertions.assertFalse((boolean)PkvInsuranceCoverageInfo.BARMENIA.getName().isEmpty());
    }

    @Test
    void shouldProvideContact() {
        Assertions.assertFalse((boolean)PkvInsuranceCoverageInfo.ALTE_OLDENBURGER.getContact().isEmpty());
    }

    @Test
    void shouldProvideGkvName() {
        GkvInsuranceCoverageInfo gkvCoverageData = GkvInsuranceCoverageInfo.ACTIMONDA;
        Assertions.assertFalse((boolean)gkvCoverageData.getName().isEmpty());
    }

    @Test
    void getIknrGKVIknr() {
        String testdata = GkvInsuranceCoverageInfo.AOK_BAYERN.getIknr();
        Assertions.assertEquals((Object)"108310400", (Object)testdata);
    }

    @ParameterizedTest(name="{0} Name must not exceed max length of 45")
    @MethodSource(value={"coverageDataImplementors"})
    void shouldNotExceedMaxNameLength(InsuranceTypeDe type, List<InsuranceCoverageInfo> data) {
        data.forEach(cid -> Assertions.assertTrue((cid.getName().length() <= 45 ? 1 : 0) != 0, (String)MessageFormat.format("{0} Insurance {1} ({2}) exceeds max length", type.getCode(), cid.getName(), cid.getIknr())));
    }

    @ParameterizedTest(name="{0} IKNRs must have length of 9 digits")
    @MethodSource(value={"coverageDataImplementors"})
    void shouldMatchIknrLength(InsuranceTypeDe type, List<InsuranceCoverageInfo> data) {
        data.forEach(icd -> Assertions.assertEquals((int)9, (int)icd.getIknr().length(), (String)MessageFormat.format("{0} Insurance {1} has more than 9 digits Nr: {2}", type.getCode(), icd.getName(), icd.getIknr())));
    }

    @ParameterizedTest(name="Random Insurance Coverage Information for {0}")
    @EnumSource(value=InsuranceTypeDe.class)
    void shouldGetRandomFor(InsuranceTypeDe insuranceKind) {
        InsuranceCoverageInfo data = InsuranceCoverageInfo.randomFor((InsuranceTypeDe)insuranceKind);
        Assertions.assertNotNull((Object)data.getIknr());
        Assertions.assertNotNull((Object)data.getName());
    }

    @Test
    void shouldGetGkvByIknr() {
        Optional element = GkvInsuranceCoverageInfo.getByIknr((String)"108018007");
        Assertions.assertTrue((boolean)element.isPresent());
        element.ifPresent(cov -> Assertions.assertEquals((Object)GkvInsuranceCoverageInfo.AOK_BAD_WUERT, (Object)cov));
    }

    @Test
    void shouldGetPkvByIknr() {
        Optional element = PkvInsuranceCoverageInfo.getByIknr((String)"168140346");
        Assertions.assertTrue((boolean)element.isPresent());
        element.ifPresent(cov -> Assertions.assertEquals((Object)PkvInsuranceCoverageInfo.ALLIANZ, (Object)cov));
    }

    @Test
    void shouldGetBGByIknr() {
        Optional element = BGInsuranceCoverageInfo.getByIknr((String)"120390887");
        Assertions.assertTrue((boolean)element.isPresent());
        element.ifPresent(cov -> Assertions.assertEquals((Object)BGInsuranceCoverageInfo.BG_BAU, (Object)cov));
    }

    @Test
    void shouldFindByAnyInsurance() {
        Optional elementGkv = InsuranceCoverageInfo.getByIknr((String)"108018007");
        Assertions.assertTrue((boolean)elementGkv.isPresent());
        elementGkv.ifPresent(cov -> Assertions.assertEquals((Object)GkvInsuranceCoverageInfo.AOK_BAD_WUERT, (Object)cov));
        Optional elementPkv = InsuranceCoverageInfo.getByIknr((String)"168140346");
        Assertions.assertTrue((boolean)elementPkv.isPresent());
        elementPkv.ifPresent(cov -> Assertions.assertEquals((Object)PkvInsuranceCoverageInfo.ALLIANZ, (Object)cov));
        Optional elementBg = InsuranceCoverageInfo.getByIknr((String)"120390887");
        Assertions.assertTrue((boolean)elementBg.isPresent());
        elementBg.ifPresent(cov -> Assertions.assertEquals((Object)BGInsuranceCoverageInfo.BG_BAU, (Object)cov));
    }

    @Test
    void shouldGetGkvOptions() {
        Optional options = InsuranceCoverageInfo.coverageOptionsFor((InsuranceTypeDe)InsuranceTypeDe.GKV);
        Assertions.assertTrue((boolean)options.isPresent());
        options.ifPresent(c -> Assertions.assertEquals(GkvInsuranceCoverageInfo.class, (Object)c));
    }
}

