/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.values;

import de.gematik.bbriccs.fhir.de.DeBasisProfilCodeSystem;
import de.gematik.bbriccs.fhir.de.DeBasisProfilNamingSystem;
import de.gematik.bbriccs.fhir.de.HL7CodeSystem;
import de.gematik.bbriccs.fhir.de.valueset.InsuranceTypeDe;
import de.gematik.test.erezept.fhir.exceptions.InvalidBaseANR;
import de.gematik.test.erezept.fhir.parser.profiles.systems.CommonNamingSystem;
import de.gematik.test.erezept.fhir.parser.profiles.systems.KbvNamingSystem;
import de.gematik.test.erezept.fhir.values.BaseANR;
import de.gematik.test.erezept.fhir.values.LANR;
import de.gematik.test.erezept.fhir.valuesets.QualificationType;
import java.util.Arrays;
import java.util.List;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Identifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class BaseANRTest {
    BaseANRTest() {
    }

    @Test
    void shouldCreateZANR() {
        Identifier identifier = new Identifier();
        identifier.setSystem(DeBasisProfilNamingSystem.KZBV_ZAHNARZTNUMMER.getCanonicalUrl());
        identifier.setValue("123456789");
        Coding coding = identifier.getType().getCodingFirstRep();
        coding.setSystem(DeBasisProfilCodeSystem.IDENTIFIER_TYPE_DE_BASIS.getCanonicalUrl());
        coding.setCode("ZANR");
        BaseANR anr = BaseANR.fromIdentifier((Identifier)identifier);
        Assertions.assertEquals((Object)BaseANR.ANRType.ZANR, (Object)anr.getType());
        Assertions.assertEquals((Object)"123456789", (Object)anr.getValue());
        Assertions.assertEquals((Object)DeBasisProfilCodeSystem.IDENTIFIER_TYPE_DE_BASIS.getCanonicalUrl(), (Object)anr.getCodeSystemUrl());
        Assertions.assertEquals((Object)DeBasisProfilNamingSystem.KZBV_ZAHNARZTNUMMER.getCanonicalUrl(), (Object)anr.getNamingSystemUrl());
        Assertions.assertEquals((int)anr.hashCode(), (int)anr.hashCode());
    }

    @Test
    void shouldCreateLANR() {
        Identifier identifier = new Identifier();
        identifier.setSystem(KbvNamingSystem.BASE_ANR.getCanonicalUrl());
        identifier.setValue("123456789");
        Coding coding = identifier.getType().getCodingFirstRep();
        coding.setSystem(HL7CodeSystem.HL7_V2_0203.getCanonicalUrl());
        coding.setCode("LANR");
        BaseANR anr = BaseANR.fromIdentifier((Identifier)identifier);
        Assertions.assertEquals((Object)BaseANR.ANRType.LANR, (Object)anr.getType());
        Assertions.assertEquals((Object)"123456789", (Object)anr.getValue());
        Assertions.assertEquals((Object)HL7CodeSystem.HL7_V2_0203.getCanonicalUrl(), (Object)anr.getCodeSystemUrl());
        Assertions.assertEquals((Object)KbvNamingSystem.BASE_ANR.getCanonicalUrl(), (Object)anr.getNamingSystemUrl());
    }

    @ParameterizedTest(name="Create BaseANR for QualificationType {0}")
    @EnumSource(value=QualificationType.class, names={"DOCTOR", "DENTIST"})
    void shouldCreateDependingOnQualification(QualificationType qt) {
        BaseANR anr = BaseANR.forQualification((QualificationType)qt, (String)"123456789");
        if (qt == QualificationType.DOCTOR) {
            Assertions.assertEquals((Object)BaseANR.ANRType.LANR, (Object)anr.getType());
            Assertions.assertEquals((Object)HL7CodeSystem.HL7_V2_0203.getCanonicalUrl(), (Object)anr.getCodeSystemUrl());
            Assertions.assertEquals((Object)KbvNamingSystem.BASE_ANR.getCanonicalUrl(), (Object)anr.getNamingSystemUrl());
        } else if (qt == QualificationType.DENTIST) {
            Assertions.assertEquals((Object)BaseANR.ANRType.ZANR, (Object)anr.getType());
            Assertions.assertEquals((Object)DeBasisProfilCodeSystem.IDENTIFIER_TYPE_DE_BASIS.getCanonicalUrl(), (Object)anr.getCodeSystemUrl());
            Assertions.assertEquals((Object)DeBasisProfilNamingSystem.KZBV_ZAHNARZTNUMMER.getCanonicalUrl(), (Object)anr.getNamingSystemUrl());
        } else {
            Assertions.fail();
        }
        Assertions.assertEquals((Object)"123456789", (Object)anr.getValue());
    }

    @Test
    void shouldThrowOnUnsupportedQualificationType() {
        List.of(QualificationType.DOCTOR_IN_TRAINING, QualificationType.DOCTOR_AS_REPLACEMENT, QualificationType.MIDWIFE).forEach(qt -> Assertions.assertThrows(IllegalArgumentException.class, () -> BaseANR.forQualification((QualificationType)qt, (String)"123456789")));
    }

    @Test
    void shouldThrowOnUndecidableANRCode01() {
        Identifier identifier = new Identifier();
        identifier.setSystem(DeBasisProfilNamingSystem.KZBV_ZAHNARZTNUMMER.getCanonicalUrl());
        identifier.setValue("123456789");
        Coding coding = identifier.getType().getCodingFirstRep();
        coding.setSystem(KbvNamingSystem.PRUEFNUMMER.getCanonicalUrl());
        coding.setCode("LANR");
        Assertions.assertThrows(InvalidBaseANR.class, () -> BaseANR.fromIdentifier((Identifier)identifier));
    }

    @Test
    void shouldThrowOnUndecidableANRCode02() {
        Identifier identifier = new Identifier();
        identifier.setSystem(CommonNamingSystem.ACME_IDS_PATIENT.getCanonicalUrl());
        identifier.setValue("123456789");
        Coding coding = identifier.getType().getCodingFirstRep();
        coding.setSystem(DeBasisProfilNamingSystem.KZBV_ZAHNARZTNUMMER.getCanonicalUrl());
        coding.setCode("ZANR");
        Assertions.assertThrows(InvalidBaseANR.class, () -> BaseANR.fromIdentifier((Identifier)identifier));
    }

    @Test
    void shouldThrowOnUndecidableANRCode03() {
        Identifier identifier = new Identifier();
        identifier.setSystem(DeBasisProfilNamingSystem.KZBV_ZAHNARZTNUMMER.getCanonicalUrl());
        identifier.setValue("123456789");
        Coding coding = identifier.getType().getCodingFirstRep();
        coding.setSystem(InsuranceTypeDe.CODE_SYSTEM.getCanonicalUrl());
        coding.setCode("LANR");
        Assertions.assertThrows(InvalidBaseANR.class, () -> BaseANR.fromIdentifier((Identifier)identifier));
    }

    @Test
    void shouldThrowOnUndecidableANRCode04() {
        Identifier identifier = new Identifier();
        identifier.setSystem(KbvNamingSystem.BASE_ANR.getCanonicalUrl());
        identifier.setValue("123456789");
        Coding coding = identifier.getType().getCodingFirstRep();
        coding.setSystem(HL7CodeSystem.HL7_V2_0203.getCanonicalUrl());
        coding.setCode("ZANR");
        Assertions.assertThrows(InvalidBaseANR.class, () -> BaseANR.fromIdentifier((Identifier)identifier));
    }

    @Test
    void shouldParseLANRTypeFromValidCode() {
        List<String> codes = List.of("LANR", "lanr", "Lanr");
        codes.forEach(code -> Assertions.assertEquals((Object)BaseANR.ANRType.LANR, (Object)BaseANR.ANRType.fromCode((String)code)));
    }

    @Test
    void shouldParseZANRTypeFromValidCode() {
        List<String> codes = List.of("ZANR", "zanr", "Zanr");
        codes.forEach(code -> Assertions.assertEquals((Object)BaseANR.ANRType.ZANR, (Object)BaseANR.ANRType.fromCode((String)code)));
    }

    @Test
    void shouldThrowOnInvalidTypeCode() {
        List<String> codes = List.of("Arztnummer", "Zahnarztnummer", "ZANRT", "LANRT", "");
        codes.forEach(code -> Assertions.assertThrows(IllegalArgumentException.class, () -> BaseANR.ANRType.fromCode((String)code)));
    }

    @ParameterizedTest
    @EnumSource(value=QualificationType.class, names={"MIDWIFE"}, mode=EnumSource.Mode.EXCLUDE)
    void shouldCreateValidBaseANR(QualificationType type) {
        BaseANR test = BaseANR.randomFromQualification((QualificationType)type);
        Assertions.assertTrue((boolean)test.isValid());
    }

    @Test
    void shouldDetectPractitionerFromCode() {
        Arrays.stream(BaseANR.ANRType.values()).map(type -> new Coding().setSystem(type.getCodeSystem().getCanonicalUrl()).setCode(type.getCodeType().getCode())).forEach(coding -> Assertions.assertTrue((boolean)BaseANR.isPractitioner((Coding)coding)));
    }

    @Test
    void shouldDetectPractitionerFromIdentifier() {
        Arrays.stream(BaseANR.ANRType.values()).map(type -> new Coding().setSystem(type.getCodeSystem().getCanonicalUrl()).setCode(type.getCodeType().getCode())).map(coding -> {
            Identifier id = new Identifier();
            id.getType().addCoding(coding);
            return id;
        }).forEach(identifier -> Assertions.assertTrue((boolean)BaseANR.isPractitioner((Identifier)identifier)));
    }

    @Test
    void shouldDetectInvalidPractitionerCode() {
        Arrays.stream(BaseANR.ANRType.values()).map(type -> new Coding().setSystem(type.getCodeSystem().getCanonicalUrl()).setCode(type.getCodeType().getCode() + "X")).forEach(coding -> Assertions.assertFalse((boolean)BaseANR.isPractitioner((Coding)coding)));
    }

    @Test
    void shouldDetectInvalidPractitionerSystem() {
        Arrays.stream(BaseANR.ANRType.values()).map(type -> new Coding().setSystem("X" + type.getCodeSystem().getCanonicalUrl()).setCode(type.getCodeType().getCode())).forEach(coding -> Assertions.assertFalse((boolean)BaseANR.isPractitioner((Coding)coding)));
    }

    @Test
    void shouldCheckValidLANR() {
        LANR lanr = new LANR("754236701");
        Assertions.assertTrue((boolean)lanr.isValid());
    }

    @Test
    void shouldNotCheckInvalidLANR() {
        LANR lanr = new LANR("111136701");
        Assertions.assertFalse((boolean)lanr.isValid());
    }

    @Test
    void shouldGiveValidNamingSystems() {
        List validNamingSystems = BaseANR.ANRType.validNamingSystems();
        Assertions.assertNotNull((Object)validNamingSystems);
        Assertions.assertFalse((boolean)validNamingSystems.isEmpty());
    }

    @Test
    void shouldThrowOnIllegalQualificationTypes() {
        QualificationType qt = QualificationType.MIDWIFE;
        Assertions.assertThrows(IllegalArgumentException.class, () -> BaseANR.randomFromQualification((QualificationType)qt));
    }
}

