/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.values;

import de.gematik.test.erezept.fhir.values.BGInsuranceCoverageInfo;
import java.text.MessageFormat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BGInsuranceCoverageInfoTest {
    BGInsuranceCoverageInfoTest() {
    }

    @Test
    void getNamingBGWorks() {
        Assertions.assertFalse((boolean)BGInsuranceCoverageInfo.VERKEHR_BERLIN.getName().isEmpty());
    }

    @Test
    void getNamingBGAsObjectWorks() {
        String insuranceCoverageBG = BGInsuranceCoverageInfo.BG_BAU.getName();
        Assertions.assertEquals((Object)BGInsuranceCoverageInfo.BG_BAU.getName(), (Object)insuranceCoverageBG);
    }

    @Test
    void getContactWORKS() {
        Assertions.assertFalse((boolean)BGInsuranceCoverageInfo.BG_BAU_MITTE.getContact().isEmpty());
    }

    @Test
    void getContactAsObjectWORKS() {
        String insuranceCoverageBGContact = BGInsuranceCoverageInfo.BG_CHEMIE_HAL.getContact();
        Assertions.assertEquals((Object)BGInsuranceCoverageInfo.BG_CHEMIE_HAL.getContact(), (Object)insuranceCoverageBGContact);
    }

    @Test
    void getIknr() {
        Assertions.assertFalse((boolean)BGInsuranceCoverageInfo.GUVV_OLDENBURG.getIknr().isEmpty());
    }

    @Test
    void getIknrFitsEnum() {
        String testdata = BGInsuranceCoverageInfo.BG_HANDEL_ESSEN.getIknr();
        Assertions.assertEquals((Object)"120591129", (Object)testdata);
    }

    @Test
    void maxNameLengthGKV45() {
        BGInsuranceCoverageInfo[] testdata;
        for (BGInsuranceCoverageInfo i : testdata = BGInsuranceCoverageInfo.values()) {
            Assertions.assertTrue((i.getName().length() <= 45 ? 1 : 0) != 0);
        }
    }

    @Test
    void maxNameLengthBG45WithInfo() {
        BGInsuranceCoverageInfo[] testdata;
        for (BGInsuranceCoverageInfo i : testdata = BGInsuranceCoverageInfo.values()) {
            Assertions.assertTrue((i.getName().length() <= 45 ? 1 : 0) != 0, (String)MessageFormat.format("Insurance {0} has more than 45 digits", i));
        }
    }

    @Test
    void maxIKNRLengthBGIs9() {
        BGInsuranceCoverageInfo[] testdata;
        for (BGInsuranceCoverageInfo i : testdata = BGInsuranceCoverageInfo.values()) {
            Assertions.assertEquals((int)9, (int)i.getIknr().length(), (String)MessageFormat.format("Insurance {0} has more than 9 digits Nr: {1}", i, i.getIknr()));
        }
    }
}

