/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.values;

import de.gematik.test.erezept.fhir.parser.profiles.systems.ErpWorkflowNamingSystem;
import de.gematik.test.erezept.fhir.values.AccessCode;
import org.hl7.fhir.r4.model.Identifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class AccessCodeTest {
    private static final String STRONG_ACCESS_CODE_VALUE = "c3830cacdc32d8b521dbfc02e5f7102f879f53206b5fca1d80fee3bda969ce4d";

    AccessCodeTest() {
    }

    @Test
    void shouldFailOnInvalidAccessCode() {
        AccessCode accessCode = AccessCode.fromString((String)"ffae");
        Assertions.assertFalse((boolean)accessCode.isValid());
    }

    @Test
    void shouldCheckValidAccessCode() {
        AccessCode accessCode = new AccessCode(STRONG_ACCESS_CODE_VALUE);
        Assertions.assertTrue((boolean)accessCode.isValid());
    }

    @Test
    void shouldGenerateValidRandomAccessCodes() {
        AccessCode accessCode = AccessCode.random();
        Assertions.assertTrue((boolean)accessCode.isValid());
    }

    @ParameterizedTest
    @EnumSource(value=ErpWorkflowNamingSystem.class, names={"ACCESS_CODE_121", "ACCESS_CODE"})
    void shouldDetectAccessCodes(ErpWorkflowNamingSystem ns) {
        Identifier identifier = new Identifier();
        identifier.setSystem(ns.getCanonicalUrl()).setValue(STRONG_ACCESS_CODE_VALUE);
        Assertions.assertTrue((boolean)AccessCode.isAccessCode((Identifier)identifier));
    }
}

