/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.util;

import de.gematik.bbriccs.utils.PrivateConstructorsUtil;
import de.gematik.test.erezept.fhir.util.IdentifierUtil;
import org.hl7.fhir.r4.model.UriType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IdentifierUtilTest {
    IdentifierUtilTest() {
    }

    @Test
    void shouldNotInstantiate() {
        Assertions.assertTrue((boolean)PrivateConstructorsUtil.isUtilityConstructor(IdentifierUtil.class));
    }

    @Test
    void testResourcedId() {
        String id = "ef0db1ef-ed28-4d01-9b3c-599bcd9c7849";
        String input = "Coverage/ef0db1ef-ed28-4d01-9b3c-599bcd9c7849";
        Assertions.assertEquals((Object)"ef0db1ef-ed28-4d01-9b3c-599bcd9c7849", (Object)IdentifierUtil.getUnqualifiedId((String)"Coverage/ef0db1ef-ed28-4d01-9b3c-599bcd9c7849"));
    }

    @Test
    void testFullUrl() {
        String id = "ef0db1ef-ed28-4d01-9b3c-599bcd9c7849";
        String input = "http://pvs.praxis.local/fhir/Medication/ef0db1ef-ed28-4d01-9b3c-599bcd9c7849";
        Assertions.assertEquals((Object)"ef0db1ef-ed28-4d01-9b3c-599bcd9c7849", (Object)IdentifierUtil.getUnqualifiedId((String)"http://pvs.praxis.local/fhir/Medication/ef0db1ef-ed28-4d01-9b3c-599bcd9c7849"));
    }

    @Test
    void testFullUrlUrnUuid() {
        String id = "ef0db1ef-ed28-4d01-9b3c-599bcd9c7849";
        String value = "urn:uuid:ef0db1ef-ed28-4d01-9b3c-599bcd9c7849";
        UriType input = new UriType("urn:uuid:ef0db1ef-ed28-4d01-9b3c-599bcd9c7849");
        Assertions.assertEquals((Object)"ef0db1ef-ed28-4d01-9b3c-599bcd9c7849", (Object)IdentifierUtil.getUnqualifiedId((UriType)input));
    }

    @Test
    void testOnlyId() {
        String id = "ef0db1ef-ed28-4d01-9b3c-599bcd9c7849";
        Assertions.assertEquals((Object)"ef0db1ef-ed28-4d01-9b3c-599bcd9c7849", (Object)IdentifierUtil.getUnqualifiedId((String)"ef0db1ef-ed28-4d01-9b3c-599bcd9c7849"));
    }
}

