/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.testutil;

import de.gematik.test.erezept.fhir.parser.profiles.version.AbdaErpPkvVersion;
import de.gematik.test.erezept.fhir.parser.profiles.version.ErpWorkflowVersion;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaErpVersion;
import de.gematik.test.erezept.fhir.parser.profiles.version.KbvItaForVersion;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.provider.Arguments;

public class VersionArgumentProvider {
    public static Stream<Arguments> erpFhirProfileVersions() {
        return Stream.of(Arguments.of((Object[])new Object[]{"1.3.0"}), Arguments.of((Object[])new Object[]{"1.4.0"}));
    }

    public static Stream<Arguments> oldErpFhirProfileVersions() {
        return Stream.of(Arguments.of((Object[])new Object[]{"1.2.0"}), Arguments.of((Object[])new Object[]{"1.3.0"}));
    }

    public static Stream<Arguments> erpWorkflowVersions() {
        return Arrays.stream(ErpWorkflowVersion.values()).filter(v -> !v.equals((Object)ErpWorkflowVersion.V1_1_1)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    public static Stream<Arguments> oldErpWorkflowVersions() {
        return Arrays.stream(ErpWorkflowVersion.values()).filter(v -> !v.equals((Object)ErpWorkflowVersion.V1_1_1)).filter(v -> !v.equals((Object)ErpWorkflowVersion.V1_4_0)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    public static Stream<Arguments> kbvItaErpVersions() {
        return Arrays.stream(KbvItaErpVersion.values()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    public static Stream<Arguments> kbvItaForVersions() {
        return Arrays.stream(KbvItaForVersion.values()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    public static Stream<Arguments> kbvBundleVersions() {
        List<Object> itaErp = VersionArgumentProvider.kbvItaErpVersions().map(arguments -> arguments.get()[0]).toList();
        List<Object> itaFor = VersionArgumentProvider.kbvItaForVersions().map(arguments -> arguments.get()[0]).toList();
        Assertions.assertEquals((int)itaFor.size(), (int)itaErp.size());
        return IntStream.range(0, itaErp.size()).mapToObj(i -> Arguments.of((Object[])new Object[]{itaFor.get(i), itaErp.get(i)}));
    }

    public static Stream<Arguments> abdaErpPkvVersions() {
        return Arrays.stream(AbdaErpPkvVersion.values()).filter(v -> !v.equals((Object)AbdaErpPkvVersion.V1_1_0)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }
}

