/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.testutil;

import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.parser.FhirParser;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ValidatorUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidatorUtil.class);

    private ValidatorUtil() {
        throw new AssertionError();
    }

    public static void validateFiles(FhirParser parser, List<File> files, Consumer<Boolean> validationAssertion, boolean printResult) {
        files.forEach(file -> ValidatorUtil.validateFile(parser, file, validationAssertion, printResult));
    }

    public static void validateFile(FhirParser parser, File file, Consumer<Boolean> validationAssertion, boolean printResult) {
        log.info("Validate {}", (Object)file.getName());
        String content = ResourceLoader.readString((File)file);
        ValidationResult vr = parser.validate(content);
        if (printResult) {
            ValidatorUtil.printValidationResult(vr);
        }
        validationAssertion.accept(vr.isSuccessful());
    }

    public static ValidationResult encodeAndValidate(FhirParser parser, Resource resource) {
        return ValidatorUtil.encodeAndValidate(parser, resource, false);
    }

    public static ValidationResult encodeAndValidate(FhirParser parser, Resource resource, EncodingType encodingType) {
        return ValidatorUtil.encodeAndValidate(parser, resource, encodingType, false);
    }

    public static ValidationResult encodeAndValidate(FhirParser parser, Resource resource, boolean printEncoded) {
        return ValidatorUtil.encodeAndValidate(parser, resource, EncodingType.XML, printEncoded);
    }

    public static ValidationResult encodeAndValidate(FhirParser parser, Resource resource, EncodingType encodingType, boolean printEncoded) {
        return ValidatorUtil.encodeAndValidate(parser, resource, encodingType, printEncoded, false);
    }

    public static ValidationResult encodeAndValidate(FhirParser parser, Resource resource, EncodingType encodingType, boolean printEncoded, boolean prettyPrint) {
        String encoded = parser.encode((IBaseResource)resource, encodingType, prettyPrint);
        if (printEncoded) {
            log.info("\n\n##########\n{}\n##########", (Object)encoded);
        }
        ValidationResult result = parser.validate(encoded);
        ValidatorUtil.printValidationResult(result);
        return result;
    }

    public static void printValidationResult(ValidationResult result) {
        ValidatorUtil.printValidationResult(result, m -> !m.getSeverity().equals((Object)ResultSeverityEnum.INFORMATION));
    }

    public static void printValidationResult(ValidationResult result, Predicate<SingleValidationMessage> messageFilter) {
        if (!result.isSuccessful()) {
            String r = result.getMessages().stream().filter(messageFilter).map(m -> MessageFormat.format("[{0} in Line {3} at {1}]: {2}", m.getSeverity(), m.getLocationString(), m.getMessage(), m.getLocationLine())).collect(Collectors.joining("\n\t"));
            log.warn("--- Found Validation Messages after validation: {} ---\n\t{}\n------", (Object)result.getMessages().stream().filter(messageFilter).count(), (Object)r);
        }
    }
}

