/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.testutil;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hl7.fhir.r4.model.AuditEvent;

public class RegExUtil {
    private static final Pattern FHIR_DATETIME = Pattern.compile("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)(-(0[1-9]|1[0-2])(-(0[1-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]+)?(Z|([+\\-])((0[0-9]|1[0-3]):[0-5][0-9]|14:00)))?)?)?");
    private static final Pattern PRESCRIPTION_ID = Pattern.compile("<system value=\"https://gematik\\.de/fhir/NamingSystem/PrescriptionID\"\\W/>\\W*<value value=\"([\\w.]+)");
    private static final Pattern PRESCRIPTION_ID_121 = Pattern.compile("<system value=\"https://gematik\\.de/fhir/erp/NamingSystem/GEM_ERP_NS_PrescriptionId\"\\W/>\\W*<value value=\"([\\w.]+)");
    private static final Pattern AUDIT_EVENT_ACTION = Pattern.compile("\"action\":\\s?\"(\\w)");
    private static final Pattern AUDIT_EVENT_RECORDED = Pattern.compile("\"recorded\":\\s?\"(([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)(-(0[1-9]|1[0-2])(-(0[1-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:([0-5][0-9]|60)(\\.[0-9]+)?(Z|([+\\-])((0[0-9]|1[0-3]):[0-5][0-9]|14:00)))?)?)?)");

    private RegExUtil() {
        throw new AssertionError();
    }

    public static Optional<String> getPrescriptionIdFor121(String content) {
        return RegExUtil.match(content, PRESCRIPTION_ID_121, 1);
    }

    public static Optional<String> getPrescriptionId(String content) {
        return RegExUtil.match(content, PRESCRIPTION_ID, 1);
    }

    public static Optional<AuditEvent.AuditEventAction> getAuditEventAction(String content) {
        Optional<String> match = RegExUtil.match(content, AUDIT_EVENT_ACTION, 1);
        return match.map(AuditEvent.AuditEventAction::fromCode);
    }

    public static Optional<Date> getAuditEventRecorded(String content) {
        Optional<String> match = RegExUtil.match(content, AUDIT_EVENT_RECORDED, 1);
        return match.map(d -> Date.from(LocalDateTime.parse(d).atZone(ZoneId.systemDefault()).toInstant()));
    }

    private static Optional<String> match(String content, Pattern pattern, int groupIdx) {
        Matcher matcher = pattern.matcher(content);
        Optional<String> ret = matcher.find() ? Optional.of(matcher.group(groupIdx)) : Optional.empty();
        return ret;
    }
}

