/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.testutil;

import de.gematik.test.erezept.fhir.parser.profiles.definitions.ErpWorkflowStructDef;
import de.gematik.test.erezept.fhir.r4.erp.ErxAuditEvent;
import de.gematik.test.erezept.fhir.r4.erp.ErxAuditEventBundle;
import de.gematik.test.erezept.fhir.values.TelematikID;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.r4.model.AuditEvent;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;

public class ErxFhirTestResourceUtil {
    private ErxFhirTestResourceUtil() {
        throw new AssertionError();
    }

    public static ErxAuditEventBundle createErxAuditEventBundle(TelematikID telematikId, String agentName) {
        List<String> textItems = List.of(MessageFormat.format("{0} hat mit Ihrer eGK die Liste der offenen E-Rezepte abgerufen.", agentName), MessageFormat.format("{0} konnte aufgrund eines Fehlerfalls nicht die Liste der offenen E-Rezepte mit Ihrer eGK abrufen.", agentName), MessageFormat.format("{0} hat mit Ihrer eGK die Liste der offenen E-Rezepte abgerufen. (Offline-Check wurde akzeptiert)", agentName), MessageFormat.format("{0} konnte aufgrund eines Fehlerfalls nicht die Liste der offenen E-Rezepte mit Ihrer eGK abrufen. (Offline-Check wurde nicht akzeptiert)", agentName));
        ErxAuditEventBundle erxAuditEventBundle = new ErxAuditEventBundle();
        textItems.forEach(i -> erxAuditEventBundle.addEntry(new Bundle.BundleEntryComponent().setResource((Resource)ErxFhirTestResourceUtil.createErxAuditEvent(i, telematikId, agentName, AuditEvent.AuditEventAction.R))));
        return erxAuditEventBundle;
    }

    public static ErxAuditEvent createErxAuditEvent(String text, TelematikID telematikId, String agentName, AuditEvent.AuditEventAction action) {
        ErxAuditEvent erxAuditEvent = new ErxAuditEvent();
        erxAuditEvent.setMeta(new Meta().addProfile(ErpWorkflowStructDef.AUDIT_EVENT.getCanonicalUrl()));
        Narrative narrative = new Narrative();
        narrative.setDivAsString(MessageFormat.format("<div xmlns=\"http://www.w3.org/1999/xhtml\">{0}</div>", text));
        erxAuditEvent.setText(narrative);
        erxAuditEvent.setRecorded(Date.from(Instant.now()));
        erxAuditEvent.setAction(action);
        Reference agentReference = new Reference().setIdentifier(new Identifier().setValue((String)telematikId.getValue()));
        AuditEvent.AuditEventAgentComponent agent = erxAuditEvent.addAgent();
        agent.setWho(agentReference);
        agent.setName(agentName);
        return erxAuditEvent;
    }
}

