/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.erezept.fhir.testutil;

import ca.uhn.fhir.validation.ValidationResult;
import de.gematik.bbriccs.fhir.EncodingType;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.test.erezept.fhir.parser.FhirParser;
import java.text.MessageFormat;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Resource;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodingUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncodingUtil.class);

    private EncodingUtil() {
        throw new AssertionError();
    }

    public static String validateRoundtripEncoding(FhirParser parser, String filepath, Class<? extends Resource> clazz) {
        String originalContent = ResourceLoader.readFileFromResource((String)filepath);
        ValidationResult originalValidationResult = parser.validate(originalContent);
        Assert.assertTrue((boolean)originalValidationResult.isSuccessful());
        log.info("Validation of original File {} : {}", (Object)filepath, (Object)originalValidationResult.isSuccessful());
        EncodingType originalEncoding = EncodingType.fromString((String)filepath);
        Resource originalObject = parser.decode(clazz, originalContent, originalEncoding);
        Assert.assertNotNull((String)MessageFormat.format("{0} must result in {1}", filepath, clazz.getSimpleName()), (Object)originalObject);
        log.info("File {} parsed to {}", (Object)filepath, (Object)originalObject);
        String newOriginalContent = EncodingUtil.reEncode(parser, originalObject, originalEncoding);
        EncodingType flippedEncoding = originalEncoding.flipEncoding();
        return EncodingUtil.reEncode(parser, originalObject, flippedEncoding);
    }

    public static <T extends IBaseResource> String reEncode(FhirParser parser, T resource, EncodingType encoding) {
        String content = parser.encode(resource, encoding);
        ValidationResult vr = parser.validate(content);
        if (vr.isSuccessful()) {
            log.info("{} re-encoded to {} : {}", new Object[]{resource.getClass().getSimpleName(), encoding, vr.isSuccessful()});
        } else {
            log.error("Encoding of Resource {} produces invalid {} output with {} errors\n{}", new Object[]{resource.getClass().getSimpleName(), encoding, vr.getMessages().size(), vr.getMessages().stream().map(svm -> svm.getMessage() + " -> (line: " + svm.getLocationLine() + "; col: " + svm.getLocationCol() + ")").collect(Collectors.joining("\n"))});
        }
        Assert.assertTrue((boolean)vr.isSuccessful());
        return content;
    }
}

